/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.dom4j.Document;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.util.store.DeserializationPostInitialisable;
import org.mule.runtime.module.xml.transformer.AbstractXStreamTransformer;
import org.mule.runtime.module.xml.transformer.DomDocumentToXml;

public class XmlToObject
extends AbstractXStreamTransformer {
    private final DomDocumentToXml domTransformer = new DomDocumentToXml();

    public XmlToObject() {
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.fromType(org.w3c.dom.Document.class));
        this.registerSourceType(DataType.fromType(Document.class));
        this.setReturnDataType(DataType.OBJECT);
    }

    public Object transformMessage(Event event, Charset outputEncoding) throws TransformerException {
        Object result;
        Object src = event.getMessage().getPayload().getValue();
        if (src instanceof byte[]) {
            InputStreamReader xml = new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])src), outputEncoding);
            result = this.getXStream().fromXML((Reader)xml);
        } else {
            if (src instanceof InputStream) {
                InputStream input = (InputStream)src;
                try {
                    InputStreamReader xml = new InputStreamReader(input, outputEncoding);
                    result = this.getXStream().fromXML((Reader)xml);
                }
                catch (Exception e) {
                    throw new TransformerException((Transformer)this, (Throwable)e);
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        this.logger.warn("Exception closing stream: ", (Throwable)e);
                    }
                }
            }
            result = src instanceof String ? this.getXStream().fromXML(src.toString()) : this.getXStream().fromXML((String)this.domTransformer.transform(src));
        }
        try {
            this.postDeserialisationInit(result);
            return result;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    protected void postDeserialisationInit(Object object) throws Exception {
        if (object instanceof DeserializationPostInitialisable) {
            DeserializationPostInitialisable.Implementation.init((Object)object, (MuleContext)this.muleContext);
        }
    }
}

