/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Document;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.message.OutputHandler;
import org.mule.runtime.module.xml.transformer.AbstractXmlTransformer;
import org.mule.runtime.module.xml.transformer.DelayedResult;
import org.mule.runtime.module.xml.util.XMLUtils;
import org.w3c.dom.Element;

public class XmlToOutputHandler
extends AbstractXmlTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public XmlToOutputHandler() {
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.fromType(Source.class));
        this.registerSourceType(DataType.fromType(Document.class));
        this.registerSourceType(DataType.fromType(org.w3c.dom.Document.class));
        this.registerSourceType(DataType.fromType(Element.class));
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.fromType(OutputHandler.class));
        this.registerSourceType(DataType.fromType(XMLStreamReader.class));
        this.registerSourceType(DataType.fromType(DelayedResult.class));
        this.setReturnDataType(DataType.fromType(OutputHandler.class));
    }

    public Object transformMessage(Event event, final Charset encoding) {
        final Object src = event.getMessage().getPayload().getValue();
        return new OutputHandler(){

            public void write(Event event, OutputStream out) throws IOException {
                XmlToOutputHandler.this.writeXml(src, encoding, out);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeXml(Object src, Charset encoding, OutputStream out) throws TransformerFactoryConfigurationError, IOException {
        block8: {
            try {
                if (src instanceof XMLStreamReader) {
                    XMLStreamReader reader = (XMLStreamReader)src;
                    XMLStreamWriter writer = this.getXMLOutputFactory().createXMLStreamWriter(out);
                    try {
                        writer.writeStartDocument();
                        XMLUtils.copy(reader, writer);
                        writer.writeEndDocument();
                        break block8;
                    }
                    finally {
                        writer.close();
                        reader.close();
                    }
                }
                if (src instanceof DelayedResult) {
                    DelayedResult result = (DelayedResult)src;
                    StreamResult streamResult = new StreamResult(out);
                    result.write(streamResult);
                } else {
                    this.writeToStream(src, encoding, out);
                }
            }
            catch (Exception e) {
                IOException ioe = new IOException(e.toString());
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

