/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.Endpoint;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutingException;
import org.mule.routing.outbound.FilteringXmlMessageSplitter;

public class RoundRobinXmlSplitter
extends FilteringXmlMessageSplitter {
    protected volatile boolean enableEndpointFiltering = false;
    private boolean deterministic = true;
    private static final AtomicInteger globalCounter = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleMessage route(MuleMessage message, MuleSession session, boolean synchronous) throws RoutingException {
        try {
            String correlationId = (String)this.propertyExtractor.getProperty("MULE_CORRELATION_ID", (Object)message);
            this.initialise(message);
            MuleMessage result = null;
            List parts = (List)this.nodesContext.get();
            if (parts == null) {
                this.logger.error((Object)("There are no parts for current message. No events were routed: " + message));
                MuleMessage muleMessage = null;
                return muleMessage;
            }
            int correlationSequence = 1;
            Counter epCounter = new Counter();
            for (Document part : parts) {
                Map theProperties = (Map)this.propertiesContext.get();
                message = new DefaultMuleMessage((Object)part, new HashMap(theProperties));
                Endpoint endpoint = this.enableEndpointFiltering ? this.getEndpointForMessage(message) : (Endpoint)this.getEndpoints().get(epCounter.next());
                if (endpoint == null) {
                    this.logger.error((Object)("There was no matching endpoint for message part: " + part.asXML()));
                    continue;
                }
                try {
                    if (this.enableCorrelation != 2) {
                        boolean correlationSet;
                        boolean bl = correlationSet = message.getCorrelationId() != null;
                        if (!correlationSet && this.enableCorrelation == 0) {
                            message.setCorrelationId(correlationId);
                        }
                        int groupSize = message.getCorrelationGroupSize();
                        message.setCorrelationGroupSize(groupSize);
                        message.setCorrelationSequence(correlationSequence++);
                    }
                    if (synchronous) {
                        result = this.send(session, message, (ImmutableEndpoint)endpoint);
                        continue;
                    }
                    this.dispatch(session, message, (ImmutableEndpoint)endpoint);
                }
                catch (MuleException e) {
                    throw new CouldNotRouteOutboundMessageException(message, (ImmutableEndpoint)endpoint, (Throwable)e);
                }
            }
            MuleMessage muleMessage = result;
            return muleMessage;
        }
        finally {
            this.cleanup();
        }
    }

    protected Endpoint getEndpointForMessage(MuleMessage message) {
        for (int i = 0; i < this.endpoints.size(); ++i) {
            Endpoint endpoint = (Endpoint)this.endpoints.get(i);
            try {
                if (endpoint.getFilter() == null || endpoint.getFilter().accept(message)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Endpoint filter matched for node " + i + ". Routing message over: " + endpoint.getEndpointURI().toString()));
                    }
                    return endpoint;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)"Endpoint filter did not match");
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to create message for node at position " + i), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public void addEndpoint(Endpoint endpoint) {
        if (endpoint.getFilter() != null && !this.enableEndpointFiltering) {
            throw new IllegalStateException("Endpoints on the RoundRobin splitter router cannot have filters associated with them");
        }
        super.addEndpoint((ImmutableEndpoint)endpoint);
    }

    public boolean isEnableEndpointFiltering() {
        return this.enableEndpointFiltering;
    }

    public void setEnableEndpointFiltering(boolean enableEndpointFiltering) {
        this.enableEndpointFiltering = enableEndpointFiltering;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    private class Counter {
        private AtomicInteger counter;

        public Counter() {
            this.counter = RoundRobinXmlSplitter.this.isDeterministic() ? new AtomicInteger(0) : globalCounter;
        }

        public int next() {
            return this.counter.getAndIncrement() % RoundRobinXmlSplitter.this.getEndpoints().size();
        }
    }
}

