/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.construct;

import java.net.InetAddress;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MessageExchangePattern;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.MessageSource;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.construct.processor.FlowConstructStatisticsMessageObserver;
import org.mule.endpoint.DynamicOutboundEndpoint;
import org.mule.interceptor.LoggingInterceptor;
import org.mule.processor.StopFurtherMessageProcessingMessageProcessor;
import org.mule.processor.builder.InterceptingChainMessageProcessorBuilder;
import org.mule.transformer.TransformerTemplate;
import org.mule.util.ObjectUtils;
import org.mule.util.StringUtils;

public class WSProxy
extends AbstractFlowConstruct {
    private final AbstractProxyRequestProcessor proxyMessageProcessor;
    private final OutboundEndpoint outboundEndpoint;

    public WSProxy(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint) throws MuleException {
        this(name, muleContext, messageSource, outboundEndpoint, new DynamicWsdlProxyRequestProcessor(outboundEndpoint));
    }

    public WSProxy(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, String wsdlContents) throws MuleException {
        this(name, muleContext, messageSource, outboundEndpoint, new StaticWsdlProxyRequestProcessor(wsdlContents));
    }

    public WSProxy(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, URI wsdlUri) throws MuleException {
        this(name, muleContext, messageSource, outboundEndpoint, new DynamicWsdlProxyRequestProcessor(wsdlUri));
    }

    private WSProxy(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, AbstractProxyRequestProcessor proxyMessageProcessor) throws MuleException {
        super(name, muleContext);
        if (messageSource == null) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)("messageSource can't be null on: " + this.toString())), (FlowConstruct)this);
        }
        super.setMessageSource(messageSource);
        if (outboundEndpoint == null) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)("outboundEndpoint can't be null on: " + this.toString())), (FlowConstruct)this);
        }
        this.outboundEndpoint = outboundEndpoint;
        this.proxyMessageProcessor = proxyMessageProcessor;
    }

    protected void configureMessageProcessors(InterceptingChainMessageProcessorBuilder builder) {
        builder.chain(new MessageProcessor[]{new LoggingInterceptor()});
        builder.chain(new MessageProcessor[]{new FlowConstructStatisticsMessageObserver()});
        builder.chain(new MessageProcessor[]{this.proxyMessageProcessor});
        builder.chain(new MessageProcessor[]{new StopFurtherMessageProcessingMessageProcessor()});
        builder.chain(new MessageProcessor[]{new TransformerTemplate((TransformerTemplate.TransformerCallback)new CopyInboundToOutboundPropertiesTransformerCallback())});
        builder.chain(new MessageProcessor[]{this.outboundEndpoint});
    }

    protected void validateConstruct() throws FlowConstructInvalidException {
        super.validateConstruct();
        if (this.messageSource instanceof InboundEndpoint && !((InboundEndpoint)this.messageSource).getExchangePattern().equals((Object)MessageExchangePattern.REQUEST_RESPONSE)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)"WSProxy only works with a request-response inbound endpoint."), (FlowConstruct)this);
        }
        if (!this.outboundEndpoint.getExchangePattern().equals((Object)MessageExchangePattern.REQUEST_RESPONSE)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)"WSProxy only works with a request-response outbound endpoint."), (FlowConstruct)this);
        }
    }

    public String toString() {
        return ObjectUtils.toString((Object)((Object)this));
    }

    private static class DynamicWsdlProxyRequestProcessor
    extends AbstractProxyRequestProcessor {
        private static final String LOCALHOST = "localhost";
        private final WsdlAddressProvider wsdlAddressProvider;

        DynamicWsdlProxyRequestProcessor(URI wsdlUri) throws FlowConstructInvalidException {
            if (wsdlUri == null) {
                throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)"wsdlUri can't be null"));
            }
            final String wsdlAddress = wsdlUri.toString();
            this.wsdlAddressProvider = new WsdlAddressProvider(){

                public String get(MuleEvent event) {
                    return wsdlAddress;
                }
            };
            this.logger.info((Object)("Using url " + wsdlAddress + " as WSDL"));
        }

        DynamicWsdlProxyRequestProcessor(OutboundEndpoint outboundEndpoint) throws FlowConstructInvalidException {
            if (outboundEndpoint == null) {
                throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)"outboundEndpoint can't be null"));
            }
            final String wsAddress = outboundEndpoint.getAddress();
            if (outboundEndpoint instanceof DynamicOutboundEndpoint) {
                this.wsdlAddressProvider = new WsdlAddressProvider(){

                    public String get(MuleEvent event) {
                        String resolvedWsAddress = event.getMuleContext().getExpressionManager().parse(wsAddress, event.getMessage(), true);
                        return DynamicWsdlProxyRequestProcessor.makeWsdlAddress(resolvedWsAddress);
                    }
                };
                this.logger.info((Object)("Using dynamic WSDL with service address: " + wsAddress));
            } else {
                final String wsdlAddress = DynamicWsdlProxyRequestProcessor.makeWsdlAddress(wsAddress);
                this.wsdlAddressProvider = new WsdlAddressProvider(){

                    public String get(MuleEvent event) {
                        return wsdlAddress;
                    }
                };
                this.logger.info((Object)("Setting WSDL address to: " + wsdlAddress));
            }
        }

        private static String makeWsdlAddress(String wsAddress) {
            return StringUtils.substringBefore((String)wsAddress, (String)"?").concat("?wsdl");
        }

        protected String getWsdlContents(MuleEvent event) throws Exception {
            String proxyWsdlAddress;
            String wsdlAddress = this.wsdlAddressProvider.get(event);
            MuleContext muleContext = event.getMuleContext();
            InboundEndpoint webServiceEndpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(wsdlAddress);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving WSDL from web service with: " + webServiceEndpoint));
            }
            MuleMessage replyWSDL = webServiceEndpoint.request((long)event.getTimeout());
            String wsdlString = replyWSDL.getPayloadAsString();
            String realWsdlAddress = wsdlAddress.split("\\?")[0];
            if ((wsdlString = wsdlString.replaceAll(realWsdlAddress, proxyWsdlAddress = event.getEndpoint().getEndpointURI().getUri().toString())).indexOf(LOCALHOST) > -1) {
                wsdlString = wsdlString.replaceAll(LOCALHOST, InetAddress.getLocalHost().getHostName());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"WSDL retrieved successfully");
            }
            return wsdlString;
        }

        private static interface WsdlAddressProvider {
            public String get(MuleEvent var1);
        }
    }

    private static class StaticWsdlProxyRequestProcessor
    extends AbstractProxyRequestProcessor {
        private final String wsdlContents;

        StaticWsdlProxyRequestProcessor(String wsdlContents) throws FlowConstructInvalidException {
            if (StringUtils.isBlank((String)wsdlContents)) {
                throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)"wsdlContents can't be empty"));
            }
            this.wsdlContents = wsdlContents;
        }

        protected String getWsdlContents(MuleEvent event) throws Exception {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Serving static WSDL");
            }
            return this.wsdlContents;
        }
    }

    private static abstract class AbstractProxyRequestProcessor
    implements MessageProcessor {
        private static final String HTTP_REQUEST = "http.request";
        private static final String WSDL_PARAM_1 = "?wsdl";
        private static final String WSDL_PARAM_2 = "&wsdl";
        protected final Log logger = LogFactory.getLog(WSProxy.class);

        private AbstractProxyRequestProcessor() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            if (this.isWsdlRequest(event)) {
                return this.buildWsdlResult(event);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Forwarding SOAP message");
            }
            return event;
        }

        private MuleEvent buildWsdlResult(MuleEvent event) throws MuleException {
            try {
                String wsdlContents = this.getWsdlContents(event);
                event.getMessage().setPayload((Object)wsdlContents);
                event.setStopFurtherProcessing(true);
                return event;
            }
            catch (Exception e) {
                throw new MessagingException(MessageFactory.createStaticMessage((String)"Impossible to retrieve WSDL for proxied service"), event, (Throwable)e);
            }
        }

        private boolean isWsdlRequest(MuleEvent event) throws MuleException {
            String httpRequest = (String)event.getMessage().getInboundProperty(HTTP_REQUEST);
            if (httpRequest == null) {
                this.logger.warn((Object)("WS Proxy can't rewrite WSDL for non-HTTP " + event));
                return false;
            }
            String lowerHttpRequest = httpRequest.toLowerCase();
            return lowerHttpRequest.indexOf(WSDL_PARAM_1) != -1 || lowerHttpRequest.indexOf(WSDL_PARAM_2) != -1;
        }

        protected abstract String getWsdlContents(MuleEvent var1) throws Exception;
    }

    private static final class CopyInboundToOutboundPropertiesTransformerCallback
    implements TransformerTemplate.TransformerCallback {
        private CopyInboundToOutboundPropertiesTransformerCallback() {
        }

        public Object doTransform(MuleMessage message) throws Exception {
            for (String inboundPropertyName : message.getInboundPropertyNames()) {
                message.setOutboundProperty(inboundPropertyName, message.getInboundProperty(inboundPropertyName));
            }
            return message;
        }
    }
}

