/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.api;

import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

public class ObjectSource<T> {
    @Parameter
    @Alias(value="class")
    @Optional
    private String type;
    @Parameter
    @Optional
    private String ref;

    public ObjectSource() {
    }

    public ObjectSource(String type, String ref) {
        this.type = type;
        this.ref = ref;
    }

    public final T getObject(MuleContext muleContext) {
        boolean hasType = !StringUtils.isBlank((String)this.type);
        boolean hasRef = !StringUtils.isBlank((String)this.ref);
        Preconditions.checkArgument((!hasType || !hasRef ? 1 : 0) != 0, (String)"type and ref attributes are mutually exclusive. Please provide only one of them");
        Preconditions.checkArgument((boolean)(hasType ^ hasRef), (String)"One of class or ref attributes are required. Please provide one of them");
        if (hasRef) {
            return this.doGetByRef(muleContext);
        }
        return this.doGetByClassName();
    }

    protected T doGetByClassName() {
        Class objectClass;
        try {
            objectClass = ClassUtils.loadClass((String)this.type, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find class " + this.type, e);
        }
        try {
            return objectClass.newInstance();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create instance of " + this.type)), (Throwable)e);
        }
    }

    protected T doGetByRef(MuleContext muleContext) {
        return (T)muleContext.getRegistry().get(this.ref);
    }

    public final String getType() {
        return this.type;
    }

    public final String getRef() {
        return this.ref;
    }
}

