/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import java.util.Locale;
import org.mule.api.MuleEvent;
import org.mule.config.i18n.Message;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.extension.validation.internal.validator.NumberType;

public class NumberValidator
extends AbstractValidator {
    private String value;
    private Locale locale;
    private String pattern;
    private Number minValue;
    private Number maxValue;
    private NumberType numberType;
    private Message errorMessage;

    public NumberValidator(String value, Locale locale, String pattern, Number minValue, Number maxValue, NumberType numberType, ValidationContext validationContext) {
        super(validationContext);
        this.value = value;
        this.locale = locale;
        this.pattern = pattern;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.numberType = numberType;
    }

    @Override
    public ValidationResult validate(MuleEvent event) {
        Comparable newValue = (Comparable)((Object)this.numberType.toNumber(this.value, this.pattern, this.locale));
        if (newValue == null) {
            this.errorMessage = this.getMessages().invalidNumberType(this.value, this.numberType.name());
            return this.fail();
        }
        if (this.minValue != null && newValue.compareTo(this.minValue) < 0) {
            this.errorMessage = this.getMessages().lowerThan(newValue, this.minValue);
            return this.fail();
        }
        if (this.maxValue != null && newValue.compareTo(this.maxValue) > 0) {
            this.errorMessage = this.getMessages().greaterThan(newValue, this.maxValue);
            return this.fail();
        }
        return ImmutableValidationResult.ok();
    }

    @Override
    protected Message getDefaultErrorMessage() {
        return this.errorMessage;
    }
}

