/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import org.mule.api.MuleEvent;
import org.mule.config.i18n.Message;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;

public class EmailValidator
extends AbstractValidator {
    private final String email;

    public EmailValidator(String email, ValidationContext validationContext) {
        super(validationContext);
        this.email = email;
    }

    @Override
    public ValidationResult validate(MuleEvent event) {
        if (!this.email.trim().equals(this.email)) {
            return this.fail();
        }
        return org.apache.commons.validator.routines.EmailValidator.getInstance().isValid(this.email) ? ImmutableValidationResult.ok() : this.fail();
    }

    @Override
    protected Message getDefaultErrorMessage() {
        return this.getMessages().invalidEmail(this.email);
    }
}

