/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.extension.annotations.Parameter;
import org.mule.extension.annotations.param.Optional;
import org.mule.util.ClassUtils;
import org.mule.util.Preconditions;

public class ObjectSource<T> {
    @Parameter(alias="class")
    @Optional
    private String type;
    @Parameter
    @Optional
    private String ref;

    public ObjectSource() {
    }

    public ObjectSource(String type, String ref) {
        this.type = type;
        this.ref = ref;
    }

    public final T getObject(MuleContext muleContext) {
        boolean hasType = !StringUtils.isBlank((String)this.type);
        boolean hasRef = !StringUtils.isBlank((String)this.ref);
        Preconditions.checkArgument((!hasType || !hasRef ? 1 : 0) != 0, (String)"type and ref attributes are mutually exclusive. Please provide only one of them");
        Preconditions.checkArgument((boolean)(hasType ^ hasRef), (String)"One of class or ref attributes are required. Please provide one of them");
        if (hasRef) {
            return this.doGetByRef(muleContext);
        }
        return this.doGetByClassName();
    }

    protected T doGetByClassName() {
        Class objectClass;
        try {
            objectClass = ClassUtils.loadClass((String)this.type, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find class " + this.type, e);
        }
        try {
            return objectClass.newInstance();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)("Could not create instance of " + this.type)), (Throwable)e);
        }
    }

    protected T doGetByRef(MuleContext muleContext) {
        return (T)muleContext.getRegistry().get(this.ref);
    }

    public final String getType() {
        return this.type;
    }

    public final String getRef() {
        return this.ref;
    }
}

