/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.NestedProcessor;
import org.mule.extension.annotations.ImplementationOf;
import org.mule.extension.annotations.Operation;
import org.mule.extension.annotations.RestrictedTo;
import org.mule.extension.validation.api.MultipleValidationException;
import org.mule.extension.validation.api.MultipleValidationResult;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableMultipleValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationExtension;
import org.mule.util.ExceptionUtils;

@ImplementationOf(value=ValidationExtension.class)
public final class ValidationStrategies {
    private final ValidationExtension config;

    public ValidationStrategies(ValidationExtension config) {
        this.config = config;
    }

    @Operation
    public void all(@RestrictedTo(value=ValidationExtension.class) List<NestedProcessor> validations, MuleEvent muleEvent) throws MultipleValidationException {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(validations.size());
        for (NestedProcessor validation : validations) {
            try {
                validation.process();
            }
            catch (Exception e) {
                results.add(ImmutableValidationResult.error(ExceptionUtils.getRootCause((Throwable)e).getMessage()));
            }
        }
        MultipleValidationResult result = ImmutableMultipleValidationResult.of(results);
        if (result.isError()) {
            throw new MultipleValidationException(result, muleEvent);
        }
    }
}

