/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.http.alternative;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.api.transport.OutputHandler;
import org.mule.client.DefaultLocalMuleClient;
import org.mule.twitter.MuleHttpResponse;
import twitter4j.TwitterException;
import twitter4j.internal.http.HttpClient;
import twitter4j.internal.http.HttpClientConfiguration;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.http.HttpRequest;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.http.RequestMethod;

public class HttpClientImpl
implements HttpClient {
    private static MuleClient client;
    private static MuleContext context;
    private final HttpClientConfiguration httpConf;

    public HttpClientImpl(HttpClientConfiguration conf) {
        this.httpConf = conf;
    }

    public HttpResponse request(final HttpRequest req) throws TwitterException {
        String authorizationHeader;
        Object body = "";
        final boolean hasFile = HttpParameter.containsFile((HttpParameter[])req.getParameters());
        String ctBoundary = "----Twitter4J-upload" + System.currentTimeMillis();
        final String boundary = "--" + ctBoundary;
        if (req.getMethod().equals((Object)RequestMethod.POST)) {
            body = new OutputHandler(){

                public void write(MuleEvent event, OutputStream os) throws IOException {
                    if (req.getMethod() == RequestMethod.POST) {
                        if (hasFile) {
                            DataOutputStream out = new DataOutputStream(os);
                            for (HttpParameter param : req.getParameters()) {
                                if (param.isFile()) {
                                    out.writeBytes(boundary + "\r\n");
                                    out.writeBytes("Content-Disposition: form-data; name=\"" + param.getName() + "\"; filename=\"" + param.getFile().getName() + "\"\r\n");
                                    out.writeBytes("Content-Type: " + param.getContentType() + "\r\n\r\n");
                                    BufferedInputStream in = new BufferedInputStream(param.hasFileBody() ? param.getFileBody() : new FileInputStream(param.getFile()));
                                    int buff = 0;
                                    while ((buff = in.read()) != -1) {
                                        out.write(buff);
                                    }
                                    out.writeBytes("\r\n");
                                    in.close();
                                    continue;
                                }
                                out.writeBytes(boundary + "\r\n");
                                out.writeBytes("Content-Disposition: form-data; name=\"" + param.getName() + "\"\r\n");
                                out.writeBytes("Content-Type: text/plain; charset=UTF-8\r\n\r\n");
                                out.write(param.getValue().getBytes("UTF-8"));
                                out.writeBytes("\r\n");
                            }
                            out.writeBytes(boundary + "--\r\n");
                            out.writeBytes("\r\n");
                        } else {
                            String postParam = HttpParameter.encodeParameters((HttpParameter[])req.getParameters());
                            byte[] bytes = postParam.getBytes("UTF-8");
                            os.write(bytes);
                        }
                        os.flush();
                        os.close();
                    }
                }
            };
        }
        DefaultMuleMessage msg = new DefaultMuleMessage(body, context);
        if (hasFile) {
            msg.setOutboundProperty("Content-Type", (Object)("multipart/form-data; boundary=" + ctBoundary));
        } else if (req.getMethod().equals((Object)RequestMethod.POST)) {
            msg.setOutboundProperty("Content-Type", (Object)"application/x-www-form-urlencoded");
        }
        msg.setOutboundProperty("http.method", (Object)req.getMethod().name());
        if (null != req.getAuthorization() && null != (authorizationHeader = req.getAuthorization().getAuthorizationHeader(req))) {
            msg.setOutboundProperty("Authorization", (Object)authorizationHeader);
        }
        try {
            return new MuleHttpResponse(this.httpConf, client.send(req.getURL(), (MuleMessage)msg));
        }
        catch (MuleException e) {
            throw new TwitterException((Exception)((Object)e));
        }
    }

    public void shutdown() {
    }

    public static void setMuleContext(MuleContext context) {
        HttpClientImpl.context = context;
        client = new DefaultLocalMuleClient(context);
    }
}

