/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.objectstore;

import java.io.Serializable;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.provider.CacheProviderFacade;

public class SpringCacheObjectStore<T extends Serializable>
implements ObjectStore<T> {
    private CacheProviderFacade cacheProvider;
    private CachingModel cachingModel;

    public boolean contains(Serializable key) throws ObjectStoreException {
        CacheProviderFacade cacheProviderFacade = this.cacheProvider;
        synchronized (cacheProviderFacade) {
            this.assertKeyNotNull(key);
            try {
                return this.cacheProvider.getFromCache(key, this.cachingModel) != null;
            }
            catch (Exception e) {
                throw new ObjectStoreException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Serializable key, T value) throws ObjectStoreException {
        CacheProviderFacade cacheProviderFacade = this.cacheProvider;
        synchronized (cacheProviderFacade) {
            if (this.contains(key)) {
                throw new ObjectAlreadyExistsException();
            }
            ObjectStoreValue<T> wrappedValue = new ObjectStoreValue<T>(value);
            this.cacheProvider.putInCache(key, this.cachingModel, wrappedValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T retrieve(Serializable key) throws ObjectStoreException {
        this.assertKeyNotNull(key);
        CacheProviderFacade cacheProviderFacade = this.cacheProvider;
        synchronized (cacheProviderFacade) {
            ObjectStoreValue cachedValue = (ObjectStoreValue)this.cacheProvider.getFromCache(key, this.cachingModel);
            if (cachedValue == null) {
                throw new ObjectDoesNotExistException(CoreMessages.objectNotFound((Object)key));
            }
            return cachedValue.getValue();
        }
    }

    public T remove(Serializable key) throws ObjectStoreException {
        CacheProviderFacade cacheProviderFacade = this.cacheProvider;
        synchronized (cacheProviderFacade) {
            if (this.contains(key)) {
                ObjectStoreValue objectStoreValue = (ObjectStoreValue)this.cacheProvider.getFromCache(key, this.cachingModel);
                this.cacheProvider.removeFromCache(key, this.cachingModel);
                return objectStoreValue.getValue();
            }
            throw new ObjectDoesNotExistException(CoreMessages.objectNotFound((Object)key));
        }
    }

    public boolean isPersistent() {
        return true;
    }

    public CacheProviderFacade getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(CacheProviderFacade cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public CachingModel getCachingModel() {
        return this.cachingModel;
    }

    public void setCachingModel(CachingModel cachingModel) {
        this.cachingModel = cachingModel;
    }

    private void assertKeyNotNull(Serializable key) throws ObjectStoreException {
        if (key == null) {
            throw new ObjectStoreException(CoreMessages.objectIsNull((String)"id"));
        }
    }

    public static class ObjectStoreValue<T extends Serializable>
    implements Serializable {
        private final T value;

        public ObjectStoreValue(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }
}

