/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import java.io.IOException;
import java.util.HashMap;
import org.mule.component.DefaultJavaComponent;
import org.mule.component.simple.StaticComponent;
import org.mule.config.spring.parsers.specific.SimpleComponentDefinitionParser;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StaticComponentDefinitionParser
extends SimpleComponentDefinitionParser {
    public StaticComponentDefinitionParser() {
        super(DefaultJavaComponent.class, StaticComponent.class);
    }

    @Override
    protected AbstractBeanDefinition getObjectFactoryDefinition(Element element) {
        AbstractBeanDefinition objectFactoryBeanDefinition = super.getObjectFactoryDefinition(element);
        String returnData = null;
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!"return-data".equals(list.item(i).getLocalName())) continue;
            Element rData = (Element)list.item(i);
            if (StringUtils.isNotEmpty((String)rData.getAttribute("file"))) {
                String file = rData.getAttribute("file");
                try {
                    returnData = IOUtils.getResourceAsString((String)file, this.getClass());
                    continue;
                }
                catch (IOException e) {
                    throw new BeanCreationException("Failed to load test-data resource: " + file, (Throwable)e);
                }
            }
            returnData = rData.getTextContent();
        }
        if (returnData != null) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("data", returnData);
            objectFactoryBeanDefinition.getPropertyValues().addPropertyValue("properties", props);
        }
        return objectFactoryBeanDefinition;
    }
}

