/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.component.Component;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.source.MessageSource;
import org.mule.api.transformer.Transformer;
import org.mule.config.spring.parsers.MuleDefinitionParser;
import org.mule.config.spring.parsers.MuleDefinitionParserConfiguration;
import org.mule.config.spring.parsers.PostProcessor;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.assembly.BeanAssemblerFactory;
import org.mule.config.spring.parsers.assembly.DefaultBeanAssemblerFactory;
import org.mule.config.spring.parsers.assembly.configuration.ReusablePropertyConfiguration;
import org.mule.config.spring.parsers.assembly.configuration.ValueMap;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.processor.AbstractMessageProcessorOwner;
import org.mule.routing.requestreply.AbstractAsyncRequestReplyRequester;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;
import org.mule.util.XMLUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class AbstractMuleBeanDefinitionParser
extends AbstractBeanDefinitionParser
implements MuleDefinitionParser {
    public static final String ROOT_ELEMENT = "mule";
    public static final String DOMAIN_ROOT_ELEMENT = "mule-domain";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String ATTRIBUTE_REF = "ref";
    public static final String ATTRIBUTE_REFS = "refs";
    public static final String ATTRIBUTE_REF_SUFFIX = "-ref";
    public static final String ATTRIBUTE_REFS_SUFFIX = "-refs";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private BeanAssemblerFactory beanAssemblerFactory = new DefaultBeanAssemblerFactory();
    protected ReusablePropertyConfiguration beanPropertyConfiguration = new ReusablePropertyConfiguration();
    private ParserContext parserContext;
    private BeanDefinitionRegistry registry;
    private LinkedList<PreProcessor> preProcessors = new LinkedList();
    private List<PostProcessor> postProcessors = new LinkedList<PostProcessor>();
    private Set<String> beanAttributes = new HashSet<String>();
    protected boolean singleton = false;
    private boolean allowClassAttribute = true;
    private Class<?> classConstraint = null;
    private String deprecationWarning;

    public AbstractMuleBeanDefinitionParser() {
        this.addIgnored(ATTRIBUTE_ID);
        this.addBeanFlag("org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_FORCE_RECURSE");
    }

    @Override
    public MuleDefinitionParserConfiguration addReference(String propertyName) {
        this.beanPropertyConfiguration.addReference(propertyName);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration addMapping(String propertyName, Map mappings) {
        this.beanPropertyConfiguration.addMapping(propertyName, mappings);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration addMapping(String propertyName, String mappings) {
        this.beanPropertyConfiguration.addMapping(propertyName, mappings);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration addMapping(String propertyName, ValueMap mappings) {
        this.beanPropertyConfiguration.addMapping(propertyName, mappings);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration addAlias(String alias, String propertyName) {
        this.beanPropertyConfiguration.addAlias(alias, propertyName);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration addCollection(String propertyName) {
        this.beanPropertyConfiguration.addCollection(propertyName);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration addIgnored(String propertyName) {
        this.beanPropertyConfiguration.addIgnored(propertyName);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration removeIgnored(String propertyName) {
        this.beanPropertyConfiguration.removeIgnored(propertyName);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration setIgnoredDefault(boolean ignoreAll) {
        this.beanPropertyConfiguration.setIgnoredDefault(ignoreAll);
        return this;
    }

    protected void processProperty(Attr attribute, BeanAssembler assembler) {
        assembler.extendBean(attribute);
    }

    protected void postProcess(ParserContext context, BeanAssembler assembler, Element element) {
        element.setAttribute(ATTRIBUTE_NAME, this.getBeanName(element));
        for (String attribute : this.beanAttributes) {
            assembler.setBeanFlag(attribute);
        }
        for (PostProcessor processor : this.postProcessors) {
            processor.postProcess(context, assembler, element);
        }
    }

    protected void preProcess(Element element) {
        this.parserContext = null;
        this.registry = null;
        this.beanPropertyConfiguration.reset();
        for (PreProcessor processor : this.preProcessors) {
            processor.preProcess(this.beanPropertyConfiguration, element);
        }
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
        this.preProcess(element);
        this.setParserContext(context);
        this.setRegistry(context.getRegistry());
        this.checkElementNameUnique(element);
        Class<?> beanClass = this.getClassInternal(element);
        BeanDefinitionBuilder builder = this.createBeanDefinitionBuilder(element, beanClass);
        builder.getRawBeanDefinition().setSource(context.extractSource((Object)element));
        builder.setScope(this.isSingleton() ? "singleton" : "prototype");
        if (!(Component.class.isAssignableFrom(beanClass) || MessageSource.class.isAssignableFrom(beanClass) || OutboundRouterCollection.class.isAssignableFrom(beanClass) || OutboundRouter.class.isAssignableFrom(beanClass) || AbstractMessageProcessorOwner.class.isAssignableFrom(beanClass) || MessagingExceptionHandler.class.isAssignableFrom(beanClass) || Transformer.class.isAssignableFrom(beanClass) || AbstractAsyncRequestReplyRequester.class.isAssignableFrom(beanClass))) {
            if (Initialisable.class.isAssignableFrom(beanClass)) {
                builder.setInitMethodName("initialise");
            }
            if (Disposable.class.isAssignableFrom(beanClass)) {
                builder.setDestroyMethodName("dispose");
            }
        }
        if (context.isNested()) {
            builder.setScope(context.getContainingBeanDefinition().isSingleton() ? "singleton" : "prototype");
        }
        this.doParse(element, context, builder);
        return builder.getBeanDefinition();
    }

    protected void setRegistry(BeanDefinitionRegistry registry) {
        this.registry = registry;
    }

    protected BeanDefinitionRegistry getRegistry() {
        if (null == this.registry) {
            throw new IllegalStateException("Set the registry from within doParse");
        }
        return this.registry;
    }

    protected void checkElementNameUnique(Element element) {
        if (null != element.getAttributeNode(ATTRIBUTE_NAME)) {
            String name = element.getAttribute(ATTRIBUTE_NAME);
            if (this.getRegistry().containsBeanDefinition(name)) {
                throw new IllegalArgumentException("A service named " + name + " already exists.");
            }
        }
    }

    protected BeanDefinitionBuilder createBeanDefinitionBuilder(Element element, Class<?> beanClass) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(beanClass);
        if (ClassUtils.getConstructor(beanClass, (Class[])new Class[]{MuleContext.class}, (boolean)true) != null) {
            builder.addConstructorArgReference("_muleContext");
        }
        return builder;
    }

    protected Class<?> getClassInternal(Element element) {
        Class<?> beanClass = null;
        if (this.isAllowClassAttribute()) {
            beanClass = this.getBeanClassFromAttribute(element);
        }
        if (beanClass == null) {
            beanClass = this.getBeanClass(element);
        }
        if (null != beanClass && null != this.classConstraint && !this.classConstraint.isAssignableFrom(beanClass)) {
            throw new IllegalStateException(beanClass + " not a subclass of " + this.classConstraint + " for " + XMLUtils.elementToString((Element)element));
        }
        if (null == beanClass) {
            throw new IllegalStateException("No class for element " + XMLUtils.elementToString((Element)element));
        }
        return beanClass;
    }

    protected Class<?> getBeanClassFromAttribute(Element element) {
        String att = this.beanPropertyConfiguration.getAttributeAlias(ATTRIBUTE_CLASS);
        String className = element.getAttribute(att);
        Class clazz = null;
        if (StringUtils.isNotBlank((String)className)) {
            try {
                element.removeAttribute(att);
                clazz = ClassUtils.loadClass((String)className, this.getClass());
            }
            catch (ClassNotFoundException e) {
                this.logger.error((Object)("could not load class: " + className), (Throwable)e);
            }
        }
        return clazz;
    }

    protected abstract Class<?> getBeanClass(Element var1);

    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        if (this.deprecationWarning != null && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Schema warning: Use of element <" + element.getLocalName() + "> is deprecated.  " + this.deprecationWarning));
        }
        BeanAssembler assembler = this.getBeanAssembler(element, builder);
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            this.processProperty(attribute, assembler);
        }
        this.postProcess(this.getParserContext(), assembler, element);
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext context) throws BeanDefinitionStoreException {
        return this.getBeanName(element);
    }

    protected boolean isSingleton() {
        return this.singleton;
    }

    protected BeanAssembler getBeanAssembler(Element element, BeanDefinitionBuilder bean) {
        return this.getBeanAssemblerFactory().newBeanAssembler(this.beanPropertyConfiguration, bean, this.beanPropertyConfiguration, null);
    }

    protected boolean isAllowClassAttribute() {
        return this.allowClassAttribute;
    }

    protected void setAllowClassAttribute(boolean allowClassAttribute) {
        this.allowClassAttribute = allowClassAttribute;
    }

    protected Class<?> getClassConstraint() {
        return this.classConstraint;
    }

    protected void setClassConstraint(Class<?> classConstraint) {
        this.classConstraint = classConstraint;
    }

    protected ParserContext getParserContext() {
        return this.parserContext;
    }

    protected void setParserContext(ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    protected boolean isTopLevel(Element element) {
        return element.getParentNode().getLocalName().equals(ROOT_ELEMENT) || element.getParentNode().getLocalName().equals(DOMAIN_ROOT_ELEMENT);
    }

    @Override
    public AbstractBeanDefinition muleParse(Element element, ParserContext context) {
        return this.parseInternal(element, context);
    }

    @Override
    public MuleDefinitionParserConfiguration registerPreProcessor(PreProcessor preProcessor) {
        this.preProcessors.addFirst(preProcessor);
        return this;
    }

    @Override
    public MuleDefinitionParserConfiguration registerPostProcessor(PostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
        return this;
    }

    public BeanAssemblerFactory getBeanAssemblerFactory() {
        return this.beanAssemblerFactory;
    }

    public void setBeanAssemblerFactory(BeanAssemblerFactory beanAssemblerFactory) {
        this.beanAssemblerFactory = beanAssemblerFactory;
    }

    @Override
    public String getBeanName(Element element) {
        return AutoIdUtils.getUniqueName(element, "mule-bean");
    }

    @Override
    public MuleDefinitionParserConfiguration addBeanFlag(String flag) {
        this.beanAttributes.add(flag);
        return this;
    }

    @Override
    public void setDeprecationWarning(String deprecationWarning) {
        this.deprecationWarning = deprecationWarning;
    }
}

