/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationException;
import org.mule.api.config.DomainMuleContextAwareConfigurationBuilder;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.registry.Registry;
import org.mule.config.ConfigResource;
import org.mule.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.config.i18n.MessageFactory;
import org.mule.config.spring.MuleArtifactContext;
import org.mule.config.spring.SpringRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringXmlConfigurationBuilder
extends AbstractResourceConfigurationBuilder
implements DomainMuleContextAwareConfigurationBuilder {
    public static final String MULE_DEFAULTS_CONFIG = "default-mule-config.xml";
    public static final String MULE_SPRING_CONFIG = "mule-spring-config.xml";
    public static final String MULE_MINIMAL_SPRING_CONFIG = "minimal-mule-config.xml";
    public static final String MULE_REGISTRY_BOOTSTRAP_SPRING_CONFIG = "registry-bootstrap-mule-config.xml";
    protected boolean useDefaultConfigResource = true;
    protected boolean useMinimalConfigResource = false;
    protected Registry registry;
    protected ApplicationContext domainContext;
    protected ApplicationContext parentContext;
    protected ApplicationContext applicationContext;

    public SpringXmlConfigurationBuilder(String[] configResources) throws ConfigurationException {
        super(configResources);
    }

    public SpringXmlConfigurationBuilder(String configResources) throws ConfigurationException {
        super(configResources);
    }

    public SpringXmlConfigurationBuilder(ConfigResource[] configResources) {
        super(configResources);
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        ConfigResource[] allResources;
        if (this.useMinimalConfigResource) {
            allResources = new ConfigResource[this.configResources.length + 2];
            allResources[0] = new ConfigResource(MULE_MINIMAL_SPRING_CONFIG);
            allResources[1] = new ConfigResource(MULE_SPRING_CONFIG);
            System.arraycopy(this.configResources, 0, allResources, 2, this.configResources.length);
        } else if (this.useDefaultConfigResource) {
            allResources = new ConfigResource[this.configResources.length + 4];
            allResources[0] = new ConfigResource(MULE_REGISTRY_BOOTSTRAP_SPRING_CONFIG);
            allResources[1] = new ConfigResource(MULE_MINIMAL_SPRING_CONFIG);
            allResources[2] = new ConfigResource(MULE_SPRING_CONFIG);
            allResources[3] = new ConfigResource(MULE_DEFAULTS_CONFIG);
            System.arraycopy(this.configResources, 0, allResources, 4, this.configResources.length);
        } else {
            allResources = new ConfigResource[this.configResources.length + 1];
            allResources[0] = new ConfigResource(MULE_SPRING_CONFIG);
            System.arraycopy(this.configResources, 0, allResources, 1, this.configResources.length);
        }
        this.applicationContext = this.createApplicationContext(muleContext, allResources);
        this.createSpringRegistry(muleContext, this.applicationContext);
    }

    public void unconfigure(MuleContext muleContext) {
        this.registry.dispose();
        if (muleContext != null) {
            muleContext.removeRegistry(this.registry);
        }
        this.registry = null;
        this.configured = false;
    }

    protected ApplicationContext createApplicationContext(MuleContext muleContext, ConfigResource[] configResources) throws Exception {
        return new MuleArtifactContext(muleContext, configResources);
    }

    protected void createSpringRegistry(MuleContext muleContext, ApplicationContext applicationContext) throws Exception {
        if (this.parentContext != null && this.domainContext != null) {
            throw new IllegalStateException("An application with a web xml context and domain resources is not supported");
        }
        if (this.parentContext != null) {
            this.createRegistryWithParentContext(muleContext, applicationContext, this.parentContext);
        } else if (this.domainContext != null) {
            this.createRegistryWithParentContext(muleContext, applicationContext, this.domainContext);
        } else {
            this.registry = new SpringRegistry(applicationContext, muleContext);
        }
        muleContext.addRegistry(this.registry);
        this.registry.initialise();
    }

    private void createRegistryWithParentContext(MuleContext muleContext, ApplicationContext applicationContext, ApplicationContext parentContext) throws ConfigurationException {
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            throw new ConfigurationException(MessageFactory.createStaticMessage((String)"Cannot set a parent context if the ApplicationContext does not implement ConfigurableApplicationContext"));
        }
        this.registry = new SpringRegistry((ConfigurableApplicationContext)applicationContext, parentContext, muleContext);
    }

    protected void applyLifecycle(LifecycleManager lifecycleManager) throws Exception {
        if (lifecycleManager.isPhaseComplete("start")) {
            lifecycleManager.fireLifecycle("start");
        }
    }

    public boolean isUseDefaultConfigResource() {
        return this.useDefaultConfigResource;
    }

    public void setUseDefaultConfigResource(boolean useDefaultConfigResource) {
        this.useDefaultConfigResource = useDefaultConfigResource;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setUseMinimalConfigResource(boolean useMinimalConfigResource) {
        this.useMinimalConfigResource = useMinimalConfigResource;
    }

    protected ApplicationContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(ApplicationContext parentContext) {
        this.parentContext = parentContext;
    }

    public void setDomainContext(MuleContext domainContext) {
        this.domainContext = (ApplicationContext)domainContext.getRegistry().get("springApplicationContext");
    }
}

