/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.io.InputStream;
import java.io.StringBufferInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.QName;
import org.dom4j.io.DOMReader;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.common.MuleArtifact;
import org.mule.common.MuleArtifactFactoryException;
import org.mule.common.config.XmlConfigurationCallback;
import org.mule.common.config.XmlConfigurationMuleArtifactFactory;
import org.mule.config.ConfigResource;
import org.mule.config.spring.DefaultMuleArtifact;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.w3c.dom.Element;

public class SpringXmlConfigurationMuleArtifactFactory
implements XmlConfigurationMuleArtifactFactory {
    public MuleArtifact getArtifact(Element element, XmlConfigurationCallback callback) throws MuleArtifactFactoryException {
        Document document = DocumentHelper.createDocument();
        org.dom4j.Element rootElement = document.addElement("mule", "http://www.mulesoft.org/schema/mule/core");
        try {
            rootElement.add(this.convert(element));
            this.addSchemaLocation(rootElement, element, callback);
            for (int i = 0; i < element.getAttributes().getLength(); ++i) {
                String attributeName = element.getAttributes().item(i).getLocalName();
                if (attributeName == null || !attributeName.endsWith("-ref")) continue;
                Element depenedantElement = callback.getGlobalElement(element.getAttributes().item(i).getNodeValue());
                if (depenedantElement != null) {
                    rootElement.add(this.convert(depenedantElement));
                    this.addSchemaLocation(rootElement, depenedantElement, callback);
                    continue;
                }
                throw new MuleArtifactFactoryException("Missing dependent xml element " + element.getAttributes().item(i).getLocalName());
            }
            ConfigResource config = new ConfigResource("", (InputStream)new StringBufferInputStream(document.asXML()));
            DefaultMuleContextFactory factory = new DefaultMuleContextFactory();
            MuleContext muleContext = factory.createMuleContext((ConfigurationBuilder)new SpringXmlConfigurationBuilder(new ConfigResource[]{config}));
            return new DefaultMuleArtifact(muleContext.getRegistry().lookupObject(element.getAttribute("name")));
        }
        catch (Exception e) {
            throw new MuleArtifactFactoryException("Error parsing XML", (Throwable)e);
        }
    }

    protected void addSchemaLocation(org.dom4j.Element rootElement, Element element, XmlConfigurationCallback callback) {
        StringBuffer schemaLocation = new StringBuffer();
        schemaLocation.append("http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd\n");
        schemaLocation.append(element.getNamespaceURI() + " " + callback.getSchemaLocation(element.getNamespaceURI()));
        rootElement.addAttribute(QName.get((String)"schemaLocation", (String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"), schemaLocation.toString());
    }

    public org.dom4j.Element convert(Element element) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        org.w3c.dom.Document doc1 = builder.newDocument();
        Element importedElement = (Element)doc1.importNode(element, Boolean.TRUE);
        doc1.appendChild(importedElement);
        DOMReader reader = new DOMReader();
        Document doc2 = reader.read(doc1);
        return doc2.getRootElement();
    }
}

