/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.routing.filter.Filter;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.MessageProcessorFilterPair;
import org.mule.routing.filters.AcceptAllFilter;
import org.mule.routing.filters.ExpressionFilter;
import org.springframework.beans.factory.FactoryBean;

public class MessageProcessorFilterPairFactoryBean
implements FactoryBean<MessageProcessorFilterPair>,
MuleContextAware {
    private List<MessageProcessor> messageProcessors;
    private Filter filter = new ExpressionFilter();

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setMessageProcessors(List<MessageProcessor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public void setExpression(String expression) {
        ((ExpressionFilter)this.filter).setExpression(expression);
    }

    public void setEvaluator(String evaluator) {
        ((ExpressionFilter)this.filter).setEvaluator(evaluator);
    }

    public void setCustomEvaluator(String customEvaluator) {
        ((ExpressionFilter)this.filter).setCustomEvaluator(customEvaluator);
    }

    public MessageProcessorFilterPair getObject() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        for (MessageProcessor processor : this.messageProcessors) {
            if (processor instanceof MessageProcessor) {
                builder.chain(new MessageProcessor[]{processor});
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain(new MessageProcessorBuilder[]{(MessageProcessorBuilder)processor});
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessors or MessageProcessorBuilders configured");
        }
        return this.createFilterPair((MessageProcessorChainBuilder)builder);
    }

    private MessageProcessorFilterPair createFilterPair(MessageProcessorChainBuilder builder) throws Exception {
        if (this.filter == null) {
            return new MessageProcessorFilterPair(builder.build(), (Filter)AcceptAllFilter.INSTANCE);
        }
        return new MessageProcessorFilterPair(builder.build(), this.filter);
    }

    public Class<MessageProcessorFilterPair> getObjectType() {
        return MessageProcessorFilterPair.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setMuleContext(MuleContext context) {
        if (this.filter != null && this.filter instanceof MuleContextAware) {
            ((MuleContextAware)this.filter).setMuleContext(context);
        }
    }
}

