/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.config.spring.parsers.generic.OrphanDefinitionParser;
import org.mule.construct.AsynchronousProcessingStrategy;
import org.mule.construct.Flow;
import org.mule.construct.QueuedAsynchronousProcessingStrategy;
import org.mule.construct.QueuedThreadPerProcessorProcessingStrategy;
import org.mule.construct.SynchronousProcessingStrategy;
import org.mule.construct.ThreadPerProcessorProcessingStrategy;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class FlowDefinitionParser
extends OrphanDefinitionParser {
    private static String PROCESSING_STRATEGY_ATTRIBUTE_NAME = "processingStrategy";
    private static String SYNC_PROCESSING_STRATEGY = "synchronous";
    private static String ASYNC_PROCESSING_STRATEGY = "asynchronous";
    private static String QUEUED_ASYNC_PROCESSING_STRATEGY = "queued-asynchronous";
    private static String THREAD_PER_PROCESSOR_PROCESSING_STRATEGY = "thread-per-processor";
    private static String QUEUED_THREAD_PER_PROCESSOR_PROCESSING_STRATEGY = "queued-thread-per-processor";

    public FlowDefinitionParser() {
        super(Flow.class, true);
        this.addIgnored("abstract");
        this.addIgnored("name");
        this.addIgnored("processingStrategy");
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addConstructorArgValue((Object)element.getAttribute("name"));
        builder.addConstructorArgReference("_muleContext");
        String processingStrategy = element.getAttribute(PROCESSING_STRATEGY_ATTRIBUTE_NAME);
        if (SYNC_PROCESSING_STRATEGY.equals(processingStrategy)) {
            builder.addPropertyValue(PROCESSING_STRATEGY_ATTRIBUTE_NAME, (Object)new SynchronousProcessingStrategy());
        } else if (ASYNC_PROCESSING_STRATEGY.equals(processingStrategy)) {
            builder.addPropertyValue(PROCESSING_STRATEGY_ATTRIBUTE_NAME, (Object)new AsynchronousProcessingStrategy());
        } else if (QUEUED_ASYNC_PROCESSING_STRATEGY.equals(processingStrategy)) {
            builder.addPropertyValue(PROCESSING_STRATEGY_ATTRIBUTE_NAME, (Object)new QueuedAsynchronousProcessingStrategy());
        } else if (THREAD_PER_PROCESSOR_PROCESSING_STRATEGY.equals(processingStrategy)) {
            builder.addPropertyValue(PROCESSING_STRATEGY_ATTRIBUTE_NAME, (Object)new ThreadPerProcessorProcessingStrategy());
        } else if (QUEUED_THREAD_PER_PROCESSOR_PROCESSING_STRATEGY.equals(processingStrategy)) {
            builder.addPropertyValue(PROCESSING_STRATEGY_ATTRIBUTE_NAME, (Object)new QueuedThreadPerProcessorProcessingStrategy());
        } else if (null != processingStrategy && !processingStrategy.isEmpty()) {
            builder.addPropertyValue(PROCESSING_STRATEGY_ATTRIBUTE_NAME, (Object)new RuntimeBeanReference(processingStrategy));
        }
        super.doParse(element, parserContext, builder);
    }
}

