/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.util.SpringXMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckRequiredAttributes
implements PreProcessor {
    Collection<List<String>> attributeSets = new ArrayList<List<String>>();

    public CheckRequiredAttributes(String[][] attributeNames) {
        for (int i = 0; i < attributeNames.length; ++i) {
            String[] currentSet = attributeNames[i];
            if (currentSet.length <= 0) continue;
            List<String> list = Arrays.asList(currentSet);
            this.attributeSets.add(list);
        }
    }

    @Override
    public void preProcess(PropertyConfiguration config, Element element) {
        ArrayList<List<String>> matchingSets = new ArrayList<List<String>>();
        for (List<String> currentSet : this.attributeSets) {
            if (!this.containsAllRequiredAttributes(currentSet, element)) continue;
            matchingSets.add(currentSet);
        }
        if (matchingSets.size() == 0) {
            throw new CheckRequiredAttributesException(element, this.attributeSets);
        }
    }

    private boolean containsAllRequiredAttributes(List<String> currentSet, Element element) {
        Set<String> attributes = this.collectAttributes(element);
        if (attributes.size() == 0) {
            return false;
        }
        HashSet<String> remainingElementNames = new HashSet<String>(currentSet);
        remainingElementNames.removeAll(attributes);
        return remainingElementNames.size() == 0;
    }

    private Set<String> collectAttributes(Element element) {
        HashSet<String> attributeNames = new HashSet<String>();
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String alias = SpringXMLUtils.attributeName((Attr)((Attr)attributes.item(i)));
            attributeNames.add(alias);
        }
        return attributeNames;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckRequiredAttributesException
    extends IllegalStateException {
        private static String summary(Collection<List<String>> attributeSets) {
            StringBuilder buf = new StringBuilder();
            for (List<String> set : attributeSets) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                if (set.isEmpty()) continue;
                buf.append(set.toString());
            }
            return buf.toString();
        }

        private CheckRequiredAttributesException(Element element, Collection<List<String>> attributeSets) {
            super("Element " + SpringXMLUtils.elementToString((Element)element) + " must have all attributes for one of the sets: " + CheckRequiredAttributesException.summary(attributeSets) + ".");
        }
    }
}

