/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.generic;

import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.config.spring.parsers.generic.ParentDefinitionParser;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class NamedDefinitionParser
extends ParentDefinitionParser {
    private String name;
    private boolean isDynamic = false;

    public NamedDefinitionParser() {
        this.isDynamic = true;
    }

    public NamedDefinitionParser(String name) {
        this.addIgnored("name");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected String getParentBeanName(Element element) {
        return this.name;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        if (this.isDynamic) {
            if (element.hasAttribute("name")) {
                this.setName(element.getAttribute("name"));
                element.removeAttribute("name");
            } else {
                throw new IllegalStateException("Missing name attribute for " + element.getLocalName());
            }
        }
        return super.parseInternal(element, parserContext);
    }

    protected void postProcess(ParserContext context, BeanAssembler assembler, Element element) {
        super.postProcess(context, assembler, element);
        AutoIdUtils.ensureUniqueId(element, "named");
    }
}

