/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.scripting.component;

import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.component.builder.AbstractMessageBuilder;
import org.mule.component.builder.MessageBuilderException;
import org.mule.module.scripting.component.Scriptable;

public class ScriptMessageBuilder
extends AbstractMessageBuilder
implements Initialisable {
    protected Scriptable scriptable = new Scriptable();

    public Object buildMessage(MuleMessage request, MuleMessage response) throws MessageBuilderException {
        Bindings bindings = this.scriptable.getScriptEngine().createBindings();
        this.populateBindings(bindings, request, response);
        Object result = null;
        try {
            result = this.runScript(bindings);
        }
        catch (ScriptException e) {
            throw new MessageBuilderException(response, (Throwable)e);
        }
        if (result == null) {
            throw new IllegalArgumentException("A result payload must be returned from the groovy script");
        }
        return result;
    }

    public void initialise() throws InitialisationException {
        this.scriptable.initialise();
    }

    protected void populateBindings(Bindings namespace, MuleMessage request, MuleMessage response) {
        namespace.put("request", (Object)request);
        namespace.put("response", (Object)response);
        namespace.put("service", (Object)this.service);
        namespace.put("componentNamespace", (Object)namespace);
        namespace.put("log", (Object)this.logger);
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptable.getScriptEngine();
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptable.setScriptEngine(scriptEngine);
    }

    public CompiledScript getCompiledScript() {
        return this.scriptable.getCompiledScript();
    }

    public void setCompiledScript(CompiledScript compiledScript) {
        this.scriptable.setCompiledScript(compiledScript);
    }

    public String getScriptText() {
        return this.scriptable.getScriptText();
    }

    public void setScriptText(String scriptText) {
        this.scriptable.setScriptText(scriptText);
    }

    public String getScriptFile() {
        return this.scriptable.getScriptFile();
    }

    public void setScriptFile(String scriptFile) {
        this.scriptable.setScriptFile(scriptFile);
    }

    public void setScriptEngineName(String scriptEngineName) {
        this.scriptable.setScriptEngineName(scriptEngineName);
    }

    protected void populateBindings(Bindings namespace, MuleEventContext context) {
        namespace.put("context", (Object)context);
        namespace.put("message", (Object)context.getMessage());
        namespace.put("descriptor", (Object)context.getService());
        namespace.put("componentNamespace", (Object)namespace);
        namespace.put("log", (Object)this.logger);
        namespace.put("result", new Object());
    }

    protected void compileScript(Compilable compilable) throws ScriptException {
        this.scriptable.compileScript(compilable);
    }

    protected Object evaluteScript(Bindings namespace) throws ScriptException {
        return this.scriptable.evaluteScript(namespace);
    }

    protected Object runScript(Bindings namespace) throws ScriptException {
        return this.scriptable.runScript(namespace);
    }

    protected ScriptEngine createScriptEngine() {
        return this.scriptable.createScriptEngineByName(this.scriptable.getScriptEngineName());
    }
}

