/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.script.Bindings;
import javax.script.CompiledScript;
import org.mule.RegistryContext;
import org.mule.components.script.jsr223.Scriptable;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.ReaderResource;
import org.mule.config.builders.QuickConfigurationBuilder;
import org.mule.config.builders.i18n.BuildersMessages;
import org.mule.impl.registry.TransientRegistry;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.registry.RegistryFacade;
import org.mule.util.PropertiesUtils;

public class ScriptConfigurationBuilder
extends Scriptable
implements ConfigurationBuilder {
    public static final String SCRIPT_ENGINE_NAME_PROPERTY = "org.mule.script.engine";
    protected UMOManagementContext managementContext = null;
    protected QuickConfigurationBuilder builder = null;
    protected boolean initialised = false;

    public ScriptConfigurationBuilder() throws UMOException {
        this.builder = new QuickConfigurationBuilder();
        this.managementContext = this.builder.getManagementContext();
        String scriptName = System.getProperty(SCRIPT_ENGINE_NAME_PROPERTY);
        if (scriptName == null) {
            throw new IllegalArgumentException(BuildersMessages.systemPropertyNotSet((String)SCRIPT_ENGINE_NAME_PROPERTY).getMessage());
        }
        this.setScriptEngineName(scriptName);
    }

    public ScriptConfigurationBuilder(String scriptEngineName) throws UMOException {
        this(scriptEngineName, true);
    }

    public ScriptConfigurationBuilder(String scriptEngineName, boolean createDefaultRegistry) throws UMOException {
        if (RegistryContext.getRegistry() == null && createDefaultRegistry) {
            TransientRegistry registry = TransientRegistry.createNew();
            RegistryContext.setRegistry((RegistryFacade)registry);
        }
        this.builder = new QuickConfigurationBuilder();
        this.managementContext = this.builder.getManagementContext();
        this.setScriptEngineName(scriptEngineName);
    }

    public UMOManagementContext configure(String configResources) throws ConfigurationException {
        try {
            UMOManagementContext context = this.configure(configResources, "UTF-8");
            context.start();
            return context;
        }
        catch (UMOException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public UMOManagementContext configure(String configResources, String startupPropertiesFile) throws ConfigurationException {
        try {
            ReaderResource[] readers = ReaderResource.parseResources((String)configResources, (String)"UTF-8");
            if (startupPropertiesFile != null) {
                return this.configure(readers, PropertiesUtils.loadProperties((String)startupPropertiesFile, this.getClass()));
            }
            return this.configure(readers, null);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public UMOManagementContext configure(ReaderResource[] configResources, Properties startupProperties) throws ConfigurationException {
        if (startupProperties != null) {
            this.managementContext.getRegistry().registerProperties((Map)startupProperties);
        }
        try {
            for (int i = 0; i < configResources.length; ++i) {
                ReaderResource configResource = configResources[i];
                this.setScriptFile(configResource.getDescription());
                this.initialise();
                Bindings ns = this.getScriptEngine().createBindings();
                this.populateBindings(ns);
                CompiledScript script = this.compileScript(configResource.getReader());
                script.eval(ns);
            }
            if (System.getProperty("org.mule.start.after.config", "true").equalsIgnoreCase("true") && !this.managementContext.isStarted()) {
                this.managementContext.start();
            }
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        return this.managementContext;
    }

    protected void populateBindings(Bindings bindings) {
        bindings.put("managementContext", (Object)this.managementContext);
        bindings.put("builder", (Object)this.builder);
    }

    public boolean isConfigured() {
        return this.managementContext != null;
    }
}

