/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import com.jcraft.jzlib.CRC32;
import com.jcraft.jzlib.JZlib;
import java.lang.reflect.Field;
import java.util.zip.Adler32;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.zlib.JZlibDeflate;
import org.jruby.ext.zlib.JZlibInflate;
import org.jruby.ext.zlib.JZlibRubyGzipReader;
import org.jruby.ext.zlib.JZlibRubyGzipWriter;
import org.jruby.ext.zlib.RubyGzipFile;
import org.jruby.ext.zlib.ZStream;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"Zlib"})
public class RubyZlib {
    public static final String ZLIB_VERSION = "1.2.3.3";
    public static final String VERSION = "0.6.0";
    private static final Field crc32InternalField = RubyZlib.getCRC32InternalField();

    private static final Field getCRC32InternalField() {
        try {
            Field field2 = java.util.zip.CRC32.class.getDeclaredField("crc");
            field2.setAccessible(true);
            field2.setInt(new java.util.zip.CRC32(), 1);
            return field2;
        }
        catch (NoSuchFieldException nsfe) {
            return null;
        }
        catch (IllegalAccessException iae) {
            return null;
        }
    }

    public static RubyModule createZlibModule(Ruby runtime) {
        RubyModule mZlib = runtime.defineModule("Zlib");
        mZlib.defineAnnotatedMethods(RubyZlib.class);
        RubyClass cStandardError = runtime.getStandardError();
        RubyClass cZlibError = mZlib.defineClassUnder("Error", cStandardError, cStandardError.getAllocator());
        mZlib.defineClassUnder("StreamEnd", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("StreamError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("BufError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("NeedDict", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("MemError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("VersionError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("DataError", cZlibError, cZlibError.getAllocator());
        RubyClass cGzFile = mZlib.defineClassUnder("GzipFile", runtime.getObject(), RubyGzipFile.GZIPFILE_ALLOCATOR);
        cGzFile.defineAnnotatedMethods(RubyGzipFile.class);
        cGzFile.defineClassUnder("Error", cZlibError, cZlibError.getAllocator());
        RubyClass cGzError = cGzFile.defineClassUnder("Error", cZlibError, cZlibError.getAllocator());
        if (runtime.is1_9()) {
            cGzError.addReadAttribute(runtime.getCurrentContext(), "input");
        }
        cGzError.defineAnnotatedMethods(RubyGzipFile.Error.class);
        cGzFile.defineClassUnder("CRCError", cGzError, cGzError.getAllocator());
        cGzFile.defineClassUnder("NoFooter", cGzError, cGzError.getAllocator());
        cGzFile.defineClassUnder("LengthError", cGzError, cGzError.getAllocator());
        RubyClass cGzReader = mZlib.defineClassUnder("GzipReader", cGzFile, JZlibRubyGzipReader.GZIPREADER_ALLOCATOR);
        cGzReader.includeModule(runtime.getEnumerable());
        cGzReader.defineAnnotatedMethods(JZlibRubyGzipReader.class);
        RubyClass cGzWriter = mZlib.defineClassUnder("GzipWriter", cGzFile, JZlibRubyGzipWriter.GZIPWRITER_ALLOCATOR);
        cGzWriter.defineAnnotatedMethods(JZlibRubyGzipWriter.class);
        mZlib.defineConstant("ZLIB_VERSION", runtime.newString(ZLIB_VERSION));
        mZlib.defineConstant("VERSION", runtime.newString(VERSION));
        mZlib.defineConstant("BINARY", runtime.newFixnum(0));
        mZlib.defineConstant("ASCII", runtime.newFixnum(1));
        mZlib.defineConstant("UNKNOWN", runtime.newFixnum(2));
        mZlib.defineConstant("DEF_MEM_LEVEL", runtime.newFixnum(8));
        mZlib.defineConstant("MAX_MEM_LEVEL", runtime.newFixnum(9));
        mZlib.defineConstant("OS_UNIX", runtime.newFixnum(3));
        mZlib.defineConstant("OS_UNKNOWN", runtime.newFixnum(-1));
        mZlib.defineConstant("OS_CODE", runtime.newFixnum(11));
        mZlib.defineConstant("OS_ZSYSTEM", runtime.newFixnum(8));
        mZlib.defineConstant("OS_VMCMS", runtime.newFixnum(4));
        mZlib.defineConstant("OS_VMS", runtime.newFixnum(2));
        mZlib.defineConstant("OS_RISCOS", runtime.newFixnum(13));
        mZlib.defineConstant("OS_MACOS", runtime.newFixnum(7));
        mZlib.defineConstant("OS_OS2", runtime.newFixnum(6));
        mZlib.defineConstant("OS_AMIGA", runtime.newFixnum(1));
        mZlib.defineConstant("OS_QDOS", runtime.newFixnum(12));
        mZlib.defineConstant("OS_WIN32", runtime.newFixnum(11));
        mZlib.defineConstant("OS_ATARI", runtime.newFixnum(5));
        mZlib.defineConstant("OS_MSDOS", runtime.newFixnum(0));
        mZlib.defineConstant("OS_CPM", runtime.newFixnum(9));
        mZlib.defineConstant("OS_TOPS20", runtime.newFixnum(10));
        mZlib.defineConstant("DEFAULT_STRATEGY", runtime.newFixnum(0));
        mZlib.defineConstant("FILTERED", runtime.newFixnum(1));
        mZlib.defineConstant("HUFFMAN_ONLY", runtime.newFixnum(2));
        mZlib.defineConstant("NO_FLUSH", runtime.newFixnum(0));
        mZlib.defineConstant("SYNC_FLUSH", runtime.newFixnum(2));
        mZlib.defineConstant("FULL_FLUSH", runtime.newFixnum(3));
        mZlib.defineConstant("FINISH", runtime.newFixnum(4));
        mZlib.defineConstant("NO_COMPRESSION", runtime.newFixnum(0));
        mZlib.defineConstant("BEST_SPEED", runtime.newFixnum(1));
        mZlib.defineConstant("DEFAULT_COMPRESSION", runtime.newFixnum(-1));
        mZlib.defineConstant("BEST_COMPRESSION", runtime.newFixnum(9));
        mZlib.defineConstant("MAX_WBITS", runtime.newFixnum(15));
        RubyClass cZStream = mZlib.defineClassUnder("ZStream", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        cZStream.defineAnnotatedMethods(ZStream.class);
        cZStream.undefineMethod("new");
        RubyClass cInflate = mZlib.defineClassUnder("Inflate", cZStream, JZlibInflate.INFLATE_ALLOCATOR);
        cInflate.defineAnnotatedMethods(JZlibInflate.class);
        RubyClass cDeflate = mZlib.defineClassUnder("Deflate", cZStream, JZlibDeflate.DEFLATE_ALLOCATOR);
        cDeflate.defineAnnotatedMethods(JZlibDeflate.class);
        runtime.getKernel().callMethod(runtime.getCurrentContext(), "require", (IRubyObject)runtime.newString("stringio"));
        return mZlib;
    }

    @JRubyMethod(name={"zlib_version"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject zlib_version(IRubyObject recv2) {
        RubyBasicObject res = (RubyBasicObject)((RubyModule)recv2).getConstant("ZLIB_VERSION");
        res.setTaint(true);
        return res;
    }

    @JRubyMethod(name={"crc32"}, optional=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc32(IRubyObject recv2, IRubyObject[] args2) {
        boolean slow;
        args2 = Arity.scanArgs(recv2.getRuntime(), args2, 0, 2);
        int start2 = 0;
        ByteList bytes2 = null;
        if (!args2[0].isNil()) {
            bytes2 = args2[0].convertToString().getByteList();
        }
        if (!args2[1].isNil()) {
            start2 = (int)RubyNumeric.num2long(args2[1]);
        }
        java.util.zip.CRC32 checksum = new java.util.zip.CRC32();
        boolean bl = slow = crc32InternalField == null;
        if (bytes2 != null) {
            if (start2 != 0 && !slow) {
                try {
                    crc32InternalField.setInt(checksum, start2);
                }
                catch (IllegalAccessException iae) {
                    slow = true;
                }
            }
            checksum.update(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        }
        long result2 = checksum.getValue();
        if (start2 != 0 && slow) {
            result2 = JZlib.crc32_combine((long)start2, (long)result2, (long)bytes2.length());
        }
        return recv2.getRuntime().newFixnum(result2);
    }

    @JRubyMethod(name={"adler32"}, optional=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject adler32(IRubyObject recv2, IRubyObject[] args2) {
        args2 = Arity.scanArgs(recv2.getRuntime(), args2, 0, 2);
        int start2 = 1;
        ByteList bytes2 = null;
        if (!args2[0].isNil()) {
            bytes2 = args2[0].convertToString().getByteList();
        }
        if (!args2[1].isNil()) {
            start2 = (int)RubyNumeric.num2long(args2[1]);
        }
        Adler32 checksum = new Adler32();
        if (bytes2 != null) {
            checksum.update(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        }
        long result2 = checksum.getValue();
        if (start2 != 1) {
            result2 = JZlib.adler32_combine((long)start2, (long)result2, (long)bytes2.length());
        }
        return recv2.getRuntime().newFixnum(result2);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public static IRubyObject inflate(ThreadContext context, IRubyObject recv2, IRubyObject string2) {
        return JZlibInflate.s_inflate(context, recv2, string2);
    }

    @JRubyMethod(required=1, optional=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject deflate(IRubyObject recv2, IRubyObject[] args2) {
        return JZlibDeflate.s_deflate(recv2, args2);
    }

    @JRubyMethod(name={"crc_table"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc_table(IRubyObject recv2) {
        Ruby runtime = recv2.getRuntime();
        int[] table = CRC32.getCRC32Table();
        RubyArray array = runtime.newArray(table.length);
        for (int i2 = 0; i2 < table.length; ++i2) {
            array.append(runtime.newFixnum((long)table[i2] & 0xFFFFFFFFL));
        }
        return array;
    }

    @JRubyMethod(name={"crc32_combine"}, required=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc32_combine(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        long crc1 = RubyNumeric.num2long(arg0);
        long crc2 = RubyNumeric.num2long(arg1);
        long len2 = RubyNumeric.num2long(arg2);
        long crc3 = JZlib.crc32_combine((long)crc1, (long)crc2, (long)len2);
        return recv2.getRuntime().newFixnum(crc3);
    }

    @JRubyMethod(name={"adler32_combine"}, required=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject adler32_combine(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        long adler1 = RubyNumeric.num2long(arg0);
        long adler2 = RubyNumeric.num2long(arg1);
        long len2 = RubyNumeric.num2long(arg2);
        long adler3 = JZlib.adler32_combine((long)adler1, (long)adler2, (long)len2);
        return recv2.getRuntime().newFixnum(adler3);
    }

    static RaiseException newZlibError(Ruby runtime, String message2) {
        return RubyZlib.newZlibError(runtime, "Error", message2);
    }

    static RaiseException newBufError(Ruby runtime, String message2) {
        return RubyZlib.newZlibError(runtime, "BufError", message2);
    }

    static RaiseException newDictError(Ruby runtime, String message2) {
        return RubyZlib.newZlibError(runtime, "NeedDict", message2);
    }

    static RaiseException newStreamError(Ruby runtime, String message2) {
        return RubyZlib.newZlibError(runtime, "StreamError", message2);
    }

    static RaiseException newDataError(Ruby runtime, String message2) {
        return RubyZlib.newZlibError(runtime, "DataError", message2);
    }

    static RaiseException newZlibError(Ruby runtime, String klass, String message2) {
        RubyClass errorClass = runtime.getModule("Zlib").getClass(klass);
        return new RaiseException(RubyException.newException(runtime, errorClass, message2), true);
    }

    static RaiseException newGzipFileError(Ruby runtime, String message2) {
        return RubyZlib.newGzipFileError(runtime, "Error", message2);
    }

    static RaiseException newCRCError(Ruby runtime, String message2) {
        return RubyZlib.newGzipFileError(runtime, "CRCError", message2);
    }

    static RaiseException newNoFooter(Ruby runtime, String message2) {
        return RubyZlib.newGzipFileError(runtime, "NoFooter", message2);
    }

    static RaiseException newLengthError(Ruby runtime, String message2) {
        return RubyZlib.newGzipFileError(runtime, "LengthError", message2);
    }

    static RaiseException newGzipFileError(Ruby runtime, String klass, String message2) {
        RubyClass errorClass = runtime.getModule("Zlib").getClass("GzipFile").getClass(klass);
        RubyException excn = RubyException.newException(runtime, errorClass, message2);
        if (runtime.is1_9()) {
            excn.setInstanceVariable("@input", runtime.getNil());
        }
        return new RaiseException(excn, true);
    }

    static int FIXNUMARG(IRubyObject obj, int ifnil) {
        if (obj.isNil()) {
            return ifnil;
        }
        return RubyNumeric.fix2int(obj);
    }

    @JRubyClass(name={"Zlib::DataError"}, parent="Zlib::Error")
    public static class DataError
    extends Error {
    }

    @JRubyClass(name={"Zlib::VersionError"}, parent="Zlib::Error")
    public static class VersionError
    extends Error {
    }

    @JRubyClass(name={"Zlib::MemError"}, parent="Zlib::Error")
    public static class MemError
    extends Error {
    }

    @JRubyClass(name={"Zlib::NeedDict"}, parent="Zlib::Error")
    public static class NeedDict
    extends Error {
    }

    @JRubyClass(name={"Zlib::BufError"}, parent="Zlib::Error")
    public static class BufError
    extends Error {
    }

    @JRubyClass(name={"Zlib::StreamError"}, parent="Zlib::Error")
    public static class StreamError
    extends Error {
    }

    @JRubyClass(name={"Zlib::StreamEnd"}, parent="Zlib::Error")
    public static class StreamEnd
    extends Error {
    }

    @JRubyClass(name={"Zlib::Error"}, parent="StandardError")
    public static class Error {
    }
}

