/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.DefinedMessage;

public class Colon2MethodNode
extends Colon2Node {
    public Colon2MethodNode(ISourcePosition position, Node leftNode, String name2) {
        super(position, leftNode, name2);
        assert (leftNode != null) : "class fooBar is not valid";
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        return Helpers.invoke(context, this.leftNode.interpret(runtime, context, self2, aBlock), this.name, aBlock);
    }

    @Override
    public RubyString definition(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        try {
            if (this.hasMethod(this.leftNode.interpret(runtime, context, self2, aBlock))) {
                return runtime.getDefinedMessage(DefinedMessage.METHOD);
            }
        }
        catch (JumpException jumpException) {
            // empty catch block
        }
        return null;
    }

    private boolean hasMethod(IRubyObject left2) {
        return left2.getMetaClass().isMethodBound(this.name, true);
    }
}

