/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.compiler.ArgumentsCallback;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardInvocationCompiler;
import org.jruby.objectweb.asm.Label;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.InvokeDynamicSupport;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.cli.Options;

public class InvokeDynamicInvocationCompiler
extends StandardInvocationCompiler {
    public InvokeDynamicInvocationCompiler(BaseBodyCompiler methodCompiler, SkinnyMethodAdapter method2) {
        super(methodCompiler, method2);
    }

    @Override
    public void invokeAttrAssign(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, boolean selfCall, boolean expr) {
        String signature;
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        argsCallback.call(this.methodCompiler);
        switch (argsCallback.getArity()) {
            case 1: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            case 2: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            case 3: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
            }
        }
        this.method.invokedynamic("attrAssign" + (selfCall ? "Self" : "") + (expr ? "Expr" : "") + ":" + JavaNameMangler.mangleMethodName(name2), signature, InvokeDynamicSupport.getInvocationHandle(), this.methodCompiler.getScriptCompiler().getSourcename(), this.methodCompiler.getLastLine() + 1);
        if (!expr) {
            this.method.pop();
        }
    }

    @Override
    public void invokeDynamic(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, CallType callType, CompilerCallback closureArg, boolean iterator) {
        String signature;
        String invokeName;
        block31: {
            block30: {
                if (callType == CallType.SUPER) {
                    super.invokeDynamic(name2, receiverCallback, argsCallback, callType, closureArg, iterator);
                    return;
                }
                if (name2.equals("respond_to?")) {
                    super.invokeDynamic(name2, receiverCallback, argsCallback, callType, closureArg, iterator);
                    return;
                }
                this.methodCompiler.loadThreadContext();
                this.methodCompiler.loadSelf();
                if (receiverCallback != null) {
                    receiverCallback.call(this.methodCompiler);
                } else {
                    this.methodCompiler.loadSelf();
                }
                if (!iterator) break block30;
                switch (callType) {
                    case NORMAL: {
                        invokeName = "callIter";
                        break block31;
                    }
                    case FUNCTIONAL: {
                        invokeName = "fcallIter";
                        break block31;
                    }
                    case VARIABLE: {
                        invokeName = "vcallIter";
                        break block31;
                    }
                    default: {
                        throw new NotCompilableException("unknown call type " + (Object)((Object)callType));
                    }
                }
            }
            switch (callType) {
                case NORMAL: {
                    invokeName = "call";
                    break;
                }
                case FUNCTIONAL: {
                    invokeName = "fcall";
                    break;
                }
                case VARIABLE: {
                    invokeName = "vcall";
                    break;
                }
                default: {
                    throw new NotCompilableException("unknown call type " + (Object)((Object)callType));
                }
            }
        }
        invokeName = invokeName + ":" + JavaNameMangler.mangleMethodName(name2);
        if (argsCallback == null) {
            if (closureArg == null) {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
            } else {
                closureArg.call(this.methodCompiler);
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class));
            }
        } else {
            argsCallback.call(this.methodCompiler);
            if (closureArg == null) {
                switch (argsCallback.getArity()) {
                    case 1: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    case 2: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    case 3: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
                        break;
                    }
                }
            } else {
                closureArg.call(this.methodCompiler);
                switch (argsCallback.getArity()) {
                    case 1: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    case 2: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    case 3: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, Block.class));
                    }
                }
            }
        }
        this.method.invokedynamic(invokeName, signature, InvokeDynamicSupport.getInvocationHandle(), this.methodCompiler.getScriptCompiler().getSourcename(), this.methodCompiler.getLastLine() + 1);
    }

    @Override
    public void invokeDynamicVarargs(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, CallType callType, CompilerCallback closureArg, boolean iterator) {
        String signature;
        String invokeName;
        block15: {
            block14: {
                if (callType == CallType.SUPER) {
                    super.invokeDynamic(name2, receiverCallback, argsCallback, callType, closureArg, iterator);
                    return;
                }
                assert (argsCallback.getArity() == -1);
                this.methodCompiler.loadThreadContext();
                this.methodCompiler.loadSelf();
                if (receiverCallback != null) {
                    receiverCallback.call(this.methodCompiler);
                } else {
                    this.methodCompiler.loadSelf();
                }
                if (!iterator) break block14;
                switch (callType) {
                    case NORMAL: {
                        invokeName = "callIter";
                        break block15;
                    }
                    case FUNCTIONAL: {
                        invokeName = "fcallIter";
                        break block15;
                    }
                    default: {
                        throw new NotCompilableException("unknown call type " + (Object)((Object)callType));
                    }
                }
            }
            switch (callType) {
                case NORMAL: {
                    invokeName = "call";
                    break;
                }
                case FUNCTIONAL: {
                    invokeName = "fcall";
                    break;
                }
                default: {
                    throw new NotCompilableException("unknown call type " + (Object)((Object)callType));
                }
            }
        }
        invokeName = invokeName + ":" + JavaNameMangler.mangleMethodName(name2);
        argsCallback.call(this.methodCompiler);
        if (closureArg == null) {
            signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
        } else {
            closureArg.call(this.methodCompiler);
            signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, Block.class));
        }
        this.method.invokedynamic(invokeName, signature, InvokeDynamicSupport.getInvocationHandle(), this.methodCompiler.getScriptCompiler().getSourcename(), this.methodCompiler.getLastLine() + 1);
    }

    @Override
    public void invokeEqq(ArgumentsCallback receivers, final CompilerCallback argument) {
        if (argument == null) {
            super.invokeEqq(receivers, argument);
        } else if (receivers.getArity() == 1) {
            this.invokeDynamic("===", receivers, new ArgumentsCallback(){

                @Override
                public int getArity() {
                    return 1;
                }

                @Override
                public void call(BodyCompiler context) {
                    argument.call(context);
                }
            }, CallType.FUNCTIONAL, null, false);
            this.methodCompiler.isTrue();
        } else {
            super.invokeEqq(receivers, argument);
        }
    }

    @Override
    public void yieldSpecific(ArgumentsCallback argsCallback) {
        String signature;
        this.methodCompiler.loadBlock();
        this.methodCompiler.loadThreadContext();
        if (argsCallback == null) {
            signature = CodegenUtils.sig(IRubyObject.class, Block.class, ThreadContext.class);
        } else {
            argsCallback.call(this.methodCompiler);
            switch (argsCallback.getArity()) {
                case 1: {
                    signature = CodegenUtils.sig(IRubyObject.class, Block.class, ThreadContext.class, IRubyObject.class);
                    break;
                }
                case 2: {
                    signature = CodegenUtils.sig(IRubyObject.class, Block.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
                    break;
                }
                case 3: {
                    signature = CodegenUtils.sig(IRubyObject.class, Block.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class);
                    break;
                }
                default: {
                    throw new NotCompilableException("Can't do specific-arity call for > 3 args yet");
                }
            }
        }
        this.method.invokedynamic("yieldSpecific", signature, InvokeDynamicSupport.getInvocationHandle(), this.methodCompiler.getScriptCompiler().getSourcename(), this.methodCompiler.getLastLine() + 1);
    }

    @Override
    public void invokeBinaryFixnumRHS(String name2, CompilerCallback receiverCallback, final long fixnum) {
        if (!((Boolean)Options.INVOKEDYNAMIC_INVOCATION_FASTOPS.load()).booleanValue()) {
            ArgumentsCallback argumentsCallback = new ArgumentsCallback(){

                @Override
                public int getArity() {
                    return 1;
                }

                @Override
                public void call(BodyCompiler context) {
                    InvokeDynamicInvocationCompiler.this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheFixnum(InvokeDynamicInvocationCompiler.this.methodCompiler, fixnum);
                }
            };
            this.invokeDynamic(name2, receiverCallback, argumentsCallback, CallType.NORMAL, null, false);
            return;
        }
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.method.invokedynamic("fixnumOperator:" + JavaNameMangler.mangleMethodName(name2), signature, InvokeDynamicSupport.getFixnumOperatorHandle(), fixnum, this.methodCompiler.getScriptCompiler().getSourcename(), this.methodCompiler.getLastLine() + 1);
    }

    @Override
    public void invokeBinaryBooleanFixnumRHS(String name2, CompilerCallback receiverCallback, final long fixnum) {
        if (!((Boolean)Options.INVOKEDYNAMIC_INVOCATION_FASTOPS.load()).booleanValue()) {
            ArgumentsCallback argumentsCallback = new ArgumentsCallback(){

                @Override
                public int getArity() {
                    return 1;
                }

                @Override
                public void call(BodyCompiler context) {
                    InvokeDynamicInvocationCompiler.this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheFixnum(InvokeDynamicInvocationCompiler.this.methodCompiler, fixnum);
                }
            };
            this.invokeDynamic(name2, receiverCallback, argumentsCallback, CallType.NORMAL, null, false);
            this.methodCompiler.isTrue();
            return;
        }
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        String signature = CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.method.invokedynamic("fixnumBoolean:" + JavaNameMangler.mangleMethodName(name2), signature, InvokeDynamicSupport.getFixnumBooleanHandle(), fixnum, this.methodCompiler.getScriptCompiler().getSourcename(), this.methodCompiler.getLastLine() + 1);
    }

    @Override
    public void invokeBinaryFloatRHS(String name2, CompilerCallback receiverCallback, final double flote) {
        if (!((Boolean)Options.INVOKEDYNAMIC_INVOCATION_FASTOPS.load()).booleanValue()) {
            ArgumentsCallback argumentsCallback = new ArgumentsCallback(){

                @Override
                public int getArity() {
                    return 1;
                }

                @Override
                public void call(BodyCompiler context) {
                    InvokeDynamicInvocationCompiler.this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheFloat(InvokeDynamicInvocationCompiler.this.methodCompiler, flote);
                }
            };
            this.invokeDynamic(name2, receiverCallback, argumentsCallback, CallType.NORMAL, null, false);
            return;
        }
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.method.invokedynamic("floatOperator:" + JavaNameMangler.mangleMethodName(name2), signature, InvokeDynamicSupport.getFloatOperatorHandle(), flote, this.methodCompiler.getScriptCompiler().getSourcename(), this.methodCompiler.getLastLine() + 1);
    }

    @Override
    public void invokeOpAsgnWithMethod(final String operatorName, final String attrName, String attrAsgnName, CompilerCallback receiverCallback, final ArgumentsCallback argsCallback) {
        final int temp = this.methodCompiler.variableCompiler.grabTempLocal();
        receiverCallback.call(this.methodCompiler);
        this.methodCompiler.method.astore(temp);
        final CompilerCallback receiver2 = new CompilerCallback(){

            @Override
            public void call(BodyCompiler context) {
                InvokeDynamicInvocationCompiler.this.methodCompiler.method.aload(temp);
            }
        };
        ArgumentsCallback result2 = new ArgumentsCallback(){

            @Override
            public void call(BodyCompiler context) {
                CompilerCallback value2 = new CompilerCallback(){

                    @Override
                    public void call(BodyCompiler context) {
                        InvokeDynamicInvocationCompiler.this.invokeDynamic(attrName, receiver2, null, CallType.FUNCTIONAL, null, false);
                    }
                };
                InvokeDynamicInvocationCompiler.this.invokeDynamic(operatorName, value2, argsCallback, CallType.FUNCTIONAL, null, false);
            }

            @Override
            public int getArity() {
                return 1;
            }
        };
        this.invokeAttrAssign(attrAsgnName, receiver2, result2, false, true);
        this.methodCompiler.variableCompiler.releaseTempLocal();
    }

    @Override
    public void invokeOpAsgnWithOr(String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        final int temp = this.methodCompiler.variableCompiler.grabTempLocal();
        receiverCallback.call(this.methodCompiler);
        this.methodCompiler.method.astore(temp);
        CompilerCallback receiver2 = new CompilerCallback(){

            @Override
            public void call(BodyCompiler context) {
                InvokeDynamicInvocationCompiler.this.methodCompiler.method.aload(temp);
            }
        };
        this.invokeDynamic(attrName, receiver2, null, CallType.FUNCTIONAL, null, false);
        Label done = new Label();
        Label isTrue = new Label();
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.method.iftrue(done);
        this.method.pop();
        this.invokeAttrAssign(attrAsgnName, receiver2, argsCallback, false, true);
        this.method.label(done);
        this.methodCompiler.variableCompiler.releaseTempLocal();
    }

    @Override
    public void invokeOpAsgnWithAnd(String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        final int temp = this.methodCompiler.variableCompiler.grabTempLocal();
        receiverCallback.call(this.methodCompiler);
        this.methodCompiler.method.astore(temp);
        CompilerCallback receiver2 = new CompilerCallback(){

            @Override
            public void call(BodyCompiler context) {
                InvokeDynamicInvocationCompiler.this.methodCompiler.method.aload(temp);
            }
        };
        this.invokeDynamic(attrName, receiver2, null, CallType.FUNCTIONAL, null, false);
        Label done = new Label();
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.method.iffalse(done);
        this.method.pop();
        this.invokeAttrAssign(attrAsgnName, receiver2, argsCallback, false, true);
        this.method.label(done);
    }
}

