/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.reboot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.mule.module.reboot.MuleContainerBootstrap;

public final class MuleContainerBootstrapUtils {
    private static final String MULE_APPS_FILENAME = "apps";
    private static final String MULE_LIB_FILENAME = "lib/mule";
    private static final String MULE_TMP_FILENAME = "tmp";
    public static final String MULE_LOCAL_JAR_FILENAME = "mule-local-install.jar";

    private MuleContainerBootstrapUtils() {
    }

    public static boolean isStandalone() {
        return MuleContainerBootstrapUtils.getMuleHome() != null;
    }

    public static File getMuleHome() {
        String muleHome = System.getProperty("mule.home");
        return muleHome != null ? new File(muleHome) : null;
    }

    public static File getMuleAppsDir() {
        return MuleContainerBootstrapUtils.isStandalone() ? new File(MuleContainerBootstrapUtils.getMuleHome(), MULE_APPS_FILENAME) : null;
    }

    public static File getMuleLibDir() {
        return MuleContainerBootstrapUtils.isStandalone() ? new File(MuleContainerBootstrapUtils.getMuleHome(), MULE_LIB_FILENAME) : null;
    }

    public static File getMuleTmpDir() {
        return MuleContainerBootstrapUtils.isStandalone() ? new File(MuleContainerBootstrapUtils.getMuleHome(), MULE_TMP_FILENAME) : null;
    }

    public static File getMuleLocalJarFile() {
        return MuleContainerBootstrapUtils.isStandalone() ? new File(MuleContainerBootstrapUtils.getMuleLibDir(), MULE_LOCAL_JAR_FILENAME) : null;
    }

    public static URL getResource(final String resourceName, final Class<?> callingClass) {
        URL url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl != null ? cl.getResource(resourceName) : null;
            }
        });
        if (url == null) {
            url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return MuleContainerBootstrap.class.getClassLoader().getResource(resourceName);
                }
            });
        }
        if (url == null) {
            url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return callingClass.getClassLoader().getResource(resourceName);
                }
            });
        }
        return url;
    }

    public static boolean renameFile(File srcFile, File destFile) throws IOException {
        boolean isRenamed = false;
        if (srcFile != null && destFile != null && !destFile.exists() && srcFile.isFile() && !(isRenamed = srcFile.renameTo(destFile)) && srcFile.exists()) {
            isRenamed = MuleContainerBootstrapUtils.renameFileHard(srcFile, destFile);
        }
        return isRenamed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renameFileHard(File srcFile, File destFile) throws IOException {
        boolean isRenamed = false;
        if (srcFile != null && destFile != null && !destFile.exists() && srcFile.isFile()) {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(srcFile);
                out = new FileOutputStream(destFile);
                out.getChannel().transferFrom(in.getChannel(), 0L, srcFile.length());
                isRenamed = true;
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            if (isRenamed) {
                srcFile.delete();
            } else {
                destFile.delete();
            }
        }
        return isRenamed;
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = MuleContainerBootstrapUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static class ProxyInfo {
        String host;
        String port;
        String username;
        String password;

        public ProxyInfo(String host, String port) {
            this(host, port, null, null);
        }

        public ProxyInfo(String host, String port, String username, String password) {
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
        }
    }
}

