/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.pgp.LazyTransformedInputStream;
import org.mule.module.pgp.StreamTransformer;
import org.mule.module.pgp.TransformPolicy;

public abstract class AbstractTransformPolicy
implements TransformPolicy {
    protected static final Log logger = LogFactory.getLog(AbstractTransformPolicy.class);
    private AtomicBoolean startedCopying = new AtomicBoolean(false);
    private Thread copyingThread;
    private LazyTransformedInputStream inputStream;
    protected volatile boolean isClosed = false;
    private AtomicLong bytesRequested = new AtomicLong(0L);

    @Override
    public void initialize(LazyTransformedInputStream lazyTransformedInputStream) {
        this.inputStream = lazyTransformedInputStream;
    }

    @Override
    public void readRequest(long length) {
        this.bytesRequested.addAndGet(length);
        this.startCopyingThread();
    }

    protected void startCopyingThread() {
        if (this.startedCopying.compareAndSet(false, true)) {
            this.copyingThread = this.getCopyingThread();
            this.copyingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.isClosed = true;
        if (this.copyingThread != null) {
            Thread thread = this.copyingThread;
            synchronized (thread) {
                this.copyingThread.notifyAll();
            }
        }
    }

    protected abstract Thread getCopyingThread();

    protected StreamTransformer getTransformer() {
        return this.inputStream.getTransformer();
    }

    protected LazyTransformedInputStream getInputStream() {
        return this.inputStream;
    }

    protected AtomicLong getBytesRequested() {
        return this.bytesRequested;
    }

    protected abstract class TransformerWork
    extends Thread {
        protected TransformerWork() {
        }

        @Override
        public synchronized void run() {
            try {
                this.execute();
                IOUtils.closeQuietly((OutputStream)AbstractTransformPolicy.this.getInputStream().getOut());
                while (!AbstractTransformPolicy.this.isClosed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                try {
                    IOUtils.write((char[])e.getMessage().toCharArray(), (OutputStream)AbstractTransformPolicy.this.getInputStream().getOut());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected abstract void execute() throws Exception;
    }
}

