/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import cryptix.jce.provider.CryptixCrypto;
import cryptix.message.EncryptedMessage;
import cryptix.message.EncryptedMessageBuilder;
import cryptix.message.LiteralMessageBuilder;
import cryptix.message.Message;
import cryptix.message.MessageFactory;
import cryptix.message.SignedMessageBuilder;
import cryptix.openpgp.PGPArmouredMessage;
import cryptix.openpgp.provider.CryptixOpenPGP;
import cryptix.pki.KeyBundle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RequestContext;
import org.mule.api.EncryptionStrategy;
import org.mule.api.MuleEvent;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.CredentialsAccessor;
import org.mule.api.security.CryptoFailureException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.pgp.PGPCryptInfo;
import org.mule.module.pgp.PGPKeyRing;
import org.mule.security.AbstractNamedEncryptionStrategy;

public class KeyBasedEncryptionStrategy
extends AbstractNamedEncryptionStrategy {
    protected static final Log logger = LogFactory.getLog(KeyBasedEncryptionStrategy.class);
    private PGPKeyRing keyManager;
    private CredentialsAccessor credentialsAccessor;

    public byte[] encrypt(byte[] data, Object cryptInfo) throws CryptoFailureException {
        try {
            PGPCryptInfo pgpCryptInfo;
            KeyBundle publicKey;
            if (cryptInfo == null) {
                MuleEvent event = RequestContext.getEvent();
                publicKey = this.keyManager.getKeyBundle((String)this.credentialsAccessor.getCredentials(event));
                pgpCryptInfo = new PGPCryptInfo(publicKey, false);
            } else {
                pgpCryptInfo = (PGPCryptInfo)cryptInfo;
                publicKey = pgpCryptInfo.getKeyBundle();
            }
            LiteralMessageBuilder lmb = LiteralMessageBuilder.getInstance((String)"OpenPGP");
            lmb.init(data);
            Message msg = lmb.build();
            if (pgpCryptInfo.isSignRequested()) {
                SignedMessageBuilder smb = SignedMessageBuilder.getInstance((String)"OpenPGP");
                smb.init(msg);
                smb.addSigner(this.keyManager.getSecretKeyBundle(), this.keyManager.getSecretPassphrase().toCharArray());
                msg = smb.build();
            }
            EncryptedMessageBuilder emb = EncryptedMessageBuilder.getInstance((String)"OpenPGP");
            emb.init(msg);
            emb.addRecipient(publicKey);
            msg = emb.build();
            return new PGPArmouredMessage(msg).getEncoded();
        }
        catch (Exception e) {
            throw new CryptoFailureException((EncryptionStrategy)this, (Throwable)e);
        }
    }

    public byte[] decrypt(byte[] data, Object cryptInfo) throws CryptoFailureException {
        try {
            MessageFactory mf = MessageFactory.getInstance((String)"OpenPGP");
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            Collection msgs = mf.generateMessages((InputStream)in);
            Message msg = (Message)msgs.iterator().next();
            if (msg instanceof EncryptedMessage) {
                msg = ((EncryptedMessage)msg).decrypt(this.keyManager.getSecretKeyBundle(), this.keyManager.getSecretPassphrase().toCharArray());
                return new PGPArmouredMessage(msg).getEncoded();
            }
        }
        catch (Exception e) {
            throw new CryptoFailureException((EncryptionStrategy)this, (Throwable)e);
        }
        return data;
    }

    public void initialise() throws InitialisationException {
        try {
            Security.addProvider((Provider)new CryptixCrypto());
            Security.addProvider((Provider)new CryptixOpenPGP());
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToCreate((String)"KeyBasedEncryptionStrategy"), (Throwable)e, (Initialisable)this);
        }
    }

    public PGPKeyRing getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(PGPKeyRing keyManager) {
        this.keyManager = keyManager;
    }

    public CredentialsAccessor getCredentialsAccessor() {
        return this.credentialsAccessor;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }
}

