/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import cryptix.jce.provider.CryptixCrypto;
import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.message.SignedMessage;
import cryptix.openpgp.provider.CryptixOpenPGP;
import cryptix.pki.KeyBundle;
import java.security.Provider;
import java.security.Security;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleTransitionResult;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityContext;
import org.mule.api.security.SecurityContextFactory;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityProvider;
import org.mule.api.security.UnauthorisedException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.pgp.PGPAuthentication;
import org.mule.module.pgp.PGPKeyRing;
import org.mule.module.pgp.PGPSecurityContextFactory;
import org.mule.module.pgp.i18n.PGPMessages;

public class PGPSecurityProvider
implements SecurityProvider {
    private String name = "PGPSecurityProvider";
    private PGPKeyRing keyManager;
    private SecurityContextFactory factory;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Authentication authenticate(Authentication authentication) throws SecurityException {
        PGPAuthentication auth = (PGPAuthentication)authentication;
        String userId = (String)auth.getPrincipal();
        if (userId == null) {
            throw new UnauthorisedException(CoreMessages.objectIsNull((String)"UserId"));
        }
        KeyBundle userKeyBundle = this.keyManager.getKeyBundle(userId);
        if (userKeyBundle == null) {
            throw new UnauthorisedException(PGPMessages.noPublicKeyForUser(userId));
        }
        Message msg = (Message)auth.getCredentials();
        if (msg == null || !(msg instanceof SignedMessage)) {
            throw new UnauthorisedException(PGPMessages.noSignedMessageFound());
        }
        try {
            if (!((SignedMessage)msg).verify(userKeyBundle)) {
                throw new UnauthorisedException(PGPMessages.invalidSignature());
            }
        }
        catch (MessageException e) {
            throw new UnauthorisedException(PGPMessages.errorVerifySignature(), (Throwable)e);
        }
        auth.setAuthenticated(true);
        auth.setDetails(userKeyBundle);
        return auth;
    }

    public boolean supports(Class aClass) {
        return PGPAuthentication.class.isAssignableFrom(aClass);
    }

    public SecurityContext createSecurityContext(Authentication auth) throws UnknownAuthenticationTypeException {
        return this.factory.create(auth);
    }

    public LifecycleTransitionResult initialise() throws InitialisationException {
        try {
            Security.addProvider((Provider)new CryptixCrypto());
            Security.addProvider((Provider)new CryptixOpenPGP());
            this.factory = new PGPSecurityContextFactory();
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToCreate((String)"PGPProvider"), (Throwable)e, (Initialisable)this);
        }
        return LifecycleTransitionResult.OK;
    }

    public PGPKeyRing getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(PGPKeyRing keyManager) {
        this.keyManager = keyManager;
    }
}

