/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.objectstore;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import javax.inject.Inject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.registry.Registry;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.api.store.PartitionableObjectStore;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.objectstore.Config;
import org.mule.modules.objectstore.MulePropertyScope;
import org.mule.util.store.ObjectStorePartition;
import org.mule.util.store.PartitionedPersistentObjectStore;
import org.mule.util.store.QueuePersistenceObjectStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStoreConnector {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreConnector.class);
    private Config config;
    @Inject
    private Registry registry;
    @Inject
    private ObjectStoreManager objectStoreManager;
    @Inject
    private MuleContext muleContext = null;
    private final String sharedObjectStoreLockId = new Random().nextInt(1000) + "-" + System.currentTimeMillis() + "-lock";
    private ObjectStore<Serializable> objectStore;

    public void init() throws ObjectStoreException {
        logger.info("Initializing object store...");
        if (this.config.getObjectStore() == null) {
            logger.info("About to validate parameters");
            Validate.isTrue((boolean)this.hasValidParameters(), (String)"You must either provide all Entry TTL, Max Entries and Expiration Interval, or none of them.");
            Validate.notEmpty((String)this.config.getPartition(), (String)"For Object Stores that expire entries, you must provide a partition name. Any name will do as long as it's unique.");
            ObjectStore<Serializable> auxObjectStore = this.createObjectStore();
            Validate.notNull(auxObjectStore, (String)"Unable to acquire an object store.");
            this.objectStore = auxObjectStore;
        } else {
            this.objectStore = this.config.getObjectStore();
            if (this.config.getPartition() != null) {
                if (this.objectStore instanceof PartitionableObjectStore) {
                    this.objectStore = new ObjectStorePartition(this.config.getPartition(), (PartitionableObjectStore)this.objectStore);
                } else {
                    logger.warn("This is a non-partitionable ObjectStore, can't declare a partition");
                }
            }
            if ((this.objectStore instanceof QueuePersistenceObjectStore || this.objectStore instanceof PartitionedPersistentObjectStore) && !this.config.getPersistent()) {
                logger.warn("'Persistent' should be set to true when using a persistent ObjectStore.");
            }
        }
        logger.info("Object store successfully acquired.");
    }

    public boolean contains(final String key) throws ObjectStoreException {
        return this.executeInsideLock(key, new ObjectStoreTask<Boolean>(){

            @Override
            public Boolean execute() throws ObjectStoreException {
                return ObjectStoreConnector.this.objectStore.contains((Serializable)((Object)key));
            }
        });
    }

    public void dualStore(final String key, final Serializable value, final boolean overwrite) throws ObjectStoreException {
        Validate.notNull((Object)value);
        this.executeInsideLock(key, value.toString(), new ObjectStoreTask<Void>(){

            private void checkExistence(Exception parentException, Object key2, ObjectStore<Serializable> objectStore) throws ObjectStoreException {
                if (objectStore.contains((Serializable)((Object)key2.toString()))) {
                    parentException.addSuppressed(new ObjectAlreadyExistsException(CoreMessages.objectAlreadyExists((String)key2.toString())));
                }
            }

            @Override
            public Void execute() throws ObjectStoreException {
                if (overwrite) {
                    if (ObjectStoreConnector.this.objectStore.contains((Serializable)((Object)key))) {
                        ObjectStoreConnector.this.objectStore.remove((Serializable)((Object)key));
                    }
                    if (ObjectStoreConnector.this.objectStore.contains(value)) {
                        ObjectStoreConnector.this.objectStore.remove(value);
                    }
                } else {
                    ObjectAlreadyExistsException throwable = new ObjectAlreadyExistsException();
                    this.checkExistence((Exception)((Object)throwable), key, (ObjectStore<Serializable>)ObjectStoreConnector.this.objectStore);
                    this.checkExistence((Exception)((Object)throwable), value, (ObjectStore<Serializable>)ObjectStoreConnector.this.objectStore);
                    if (!ArrayUtils.isEmpty((Object[])throwable.getSuppressed())) {
                        throw throwable;
                    }
                }
                ObjectStoreConnector.this.objectStore.store((Serializable)((Object)key), value);
                ObjectStoreConnector.this.objectStore.store(value, (Serializable)((Object)key));
                return null;
            }
        });
    }

    public Serializable remove(final String key, final boolean ignoreNotExists) throws ObjectStoreException {
        return this.executeInsideLock(key, new ObjectStoreTask<Serializable>(){

            @Override
            public Serializable execute() throws ObjectStoreException {
                try {
                    return ObjectStoreConnector.this.objectStore.remove((Serializable)((Object)key));
                }
                catch (ObjectDoesNotExistException e) {
                    if (ignoreNotExists) {
                        return null;
                    }
                    throw e;
                }
            }
        });
    }

    public Object retrieve(final String key, final Serializable defaultValue, final String targetProperty, final MulePropertyScope targetScope, final MuleMessage muleMessage) throws ObjectStoreException {
        Validate.notNull((Object)((Object)targetScope));
        return this.executeInsideLock(key, new ObjectStoreTask<Object>(){

            @Override
            public Object execute() throws ObjectStoreException {
                Object availableObject;
                try {
                    availableObject = ObjectStoreConnector.this.objectStore.retrieve((Serializable)((Object)key));
                }
                catch (ObjectDoesNotExistException e) {
                    if (defaultValue != null) {
                        availableObject = defaultValue;
                    }
                    throw e;
                }
                if (StringUtils.isNotEmpty((String)targetProperty) && muleMessage != null) {
                    muleMessage.setProperty(targetProperty, availableObject, PropertyScope.get((String)targetScope.value()));
                    availableObject = muleMessage.getPayload();
                }
                return availableObject;
            }
        });
    }

    public List<String> retrieveAllKeys() throws ObjectStoreException {
        if (this.objectStore instanceof ListableObjectStore) {
            return this.executeInsideLock("", new ObjectStoreTask<List<String>>(){

                @Override
                public List<String> execute() throws ObjectStoreException {
                    List keys = ((ListableObjectStore)ObjectStoreConnector.this.objectStore).allKeys();
                    ArrayList list = Lists.newArrayList();
                    for (Serializable key : keys) {
                        if (key instanceof String) {
                            list.add((String)((Object)key));
                            continue;
                        }
                        throw new UnsupportedOperationException(String.format("The objectStore [%s] supports only keys of type: %s", ObjectStoreConnector.this.objectStore.getClass().getName(), String.class.getName()));
                    }
                    return list;
                }
            });
        }
        throw new UnsupportedOperationException(String.format("The objectStore [%s] does not support the operation 'retrieveAllKeys'", this.objectStore.getClass().getName()));
    }

    public Object retrieveAndStore(final String key, final Serializable defaultValue, final Serializable storeValue, final String targetProperty, final MulePropertyScope targetScope, final MuleMessage muleMessage) throws ObjectStoreException {
        return this.executeInsideLock(key, new ObjectStoreTask<Object>(){

            @Override
            public Object execute() throws ObjectStoreException {
                Validate.notNull((Object)storeValue);
                Validate.notNull((Object)((Object)targetScope));
                Object object = ObjectStoreConnector.this.retrieve(key, defaultValue, targetProperty, targetScope, muleMessage);
                if (ObjectStoreConnector.this.objectStore.contains((Serializable)((Object)key))) {
                    ObjectStoreConnector.this.objectStore.remove((Serializable)((Object)key));
                }
                ObjectStoreConnector.this.objectStore.store((Serializable)((Object)key), storeValue);
                ObjectStoreConnector.this.store(key, storeValue, true);
                return object;
            }
        });
    }

    public void store(final String key, final Serializable value, final boolean overwrite) throws ObjectStoreException {
        this.executeInsideLock(key, new ObjectStoreTask<Void>(){

            @Override
            public Void execute() throws ObjectStoreException {
                Validate.notNull((Object)value);
                try {
                    ObjectStoreConnector.this.objectStore.store((Serializable)((Object)key), value);
                }
                catch (ObjectAlreadyExistsException e) {
                    if (overwrite) {
                        ObjectStoreConnector.this.objectStore.remove((Serializable)((Object)key));
                        ObjectStoreConnector.this.objectStore.store((Serializable)((Object)key), value);
                    }
                    throw e;
                }
                return null;
            }
        });
    }

    public void disposeStore(String partitionName) throws ObjectStoreException {
        Validate.notNull((Object)partitionName);
        Validate.notNull((Object)this.objectStoreManager);
        ObjectStore store = this.objectStoreManager.getObjectStore(partitionName, this.config.getPersistent());
        store.clear();
        if (store instanceof ObjectStorePartition) {
            ((ObjectStorePartition)store).getBaseStore().disposePartition(partitionName);
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setObjectStoreManager(ObjectStoreManager objectStoreManager) {
        this.objectStoreManager = objectStoreManager;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeInsideLock(String key, ObjectStoreTask<T> task) throws ObjectStoreException {
        Validate.notNull((Object)key);
        Lock lock = this.muleContext.getLockFactory().createLock(this.sharedObjectStoreLockId + "-" + key);
        lock.lock();
        try {
            T t = task.execute();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    private <T> T executeInsideLock(String key1, final String key2, final ObjectStoreTask<T> task) throws ObjectStoreException {
        return this.executeInsideLock(key1, new ObjectStoreTask<T>(){

            @Override
            public T execute() throws ObjectStoreException {
                return ObjectStoreConnector.this.executeInsideLock(key2, new ObjectStoreTask<T>(){

                    @Override
                    public T execute() throws ObjectStoreException {
                        return task.execute();
                    }
                });
            }
        });
    }

    private ObjectStore<Serializable> createObjectStore() {
        if (this.allParametersAreGiven()) {
            return this.objectStoreManager.getObjectStore(this.config.getPartition(), this.config.getPersistent(), this.config.getMaxEntries().intValue(), this.config.getEntryTtl().intValue(), this.config.getExpirationInterval().intValue());
        }
        if (StringUtils.isNotEmpty((String)this.config.getPartition())) {
            return this.objectStoreManager.getObjectStore(this.config.getPartition(), this.config.getPersistent());
        }
        return (ObjectStore)this.registry.lookupObject("_defaultUserObjectStore");
    }

    private boolean hasValidParameters() {
        return this.allParametersAreEmpty() || this.allParametersAreGiven();
    }

    private boolean allParametersAreEmpty() {
        return this.config.getEntryTtl() == null && this.config.getMaxEntries() == null && this.config.getExpirationInterval() == null;
    }

    private boolean allParametersAreGiven() {
        return this.config.getEntryTtl() != null && this.config.getMaxEntries() != null && this.config.getExpirationInterval() != null;
    }

    private static interface ObjectStoreTask<T> {
        public T execute() throws ObjectStoreException;
    }
}

