/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.oauth2.internal.tokenmanager;

import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.oauth2.internal.tokenmanager.TokenManagerConfig;
import org.mule.util.AttributeEvaluator;

public class InvalidateOauthContextMessageProcessor
implements MessageProcessor,
Initialisable,
MuleContextAware {
    private TokenManagerConfig config;
    private AttributeEvaluator resourceOwnerIdEvaluator;
    private MuleContext muleContext;

    public MuleEvent process(MuleEvent event) throws MuleException {
        String resourceOwnerId = this.resourceOwnerIdEvaluator.resolveStringValue(event);
        if (resourceOwnerId == null) {
            throw new MessagingException(CoreMessages.createStaticMessage((String)"Resource owner id cannot be null"), event);
        }
        this.config.getConfigOAuthContext().clearContextForResourceOwner(resourceOwnerId);
        return event;
    }

    public void setConfig(TokenManagerConfig config) {
        this.config = config;
    }

    public void setResourceOwnerId(String resourceOwnerId) {
        this.resourceOwnerIdEvaluator = new AttributeEvaluator(resourceOwnerId);
    }

    public void initialise() throws InitialisationException {
        if (this.resourceOwnerIdEvaluator == null) {
            this.resourceOwnerIdEvaluator = new AttributeEvaluator("default");
        }
        this.resourceOwnerIdEvaluator.initialize(this.muleContext.getExpressionManager());
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

