/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.oauth2.internal;

import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.expression.ExpressionManager;
import org.mule.module.oauth2.internal.ParameterExtractor;
import org.mule.module.oauth2.internal.authorizationcode.TokenResponseConfiguration;

public class TokenResponseProcessor {
    private final TokenResponseConfiguration tokenResponseConfiguration;
    private final ExpressionManager expressionManager;
    private final boolean retrieveRefreshToken;
    private String accessToken;
    private String refreshToken;
    private String expiresIn;
    private Map<String, Object> customResponseParameters;

    public static TokenResponseProcessor createAuthorizationCodeProcessor(TokenResponseConfiguration tokenResponseConfiguration, ExpressionManager expressionManager) {
        return new TokenResponseProcessor(tokenResponseConfiguration, expressionManager, true);
    }

    public static TokenResponseProcessor createClientCredentialsProcessor(TokenResponseConfiguration tokenResponseConfiguration, ExpressionManager expressionManager) {
        return new TokenResponseProcessor(tokenResponseConfiguration, expressionManager, false);
    }

    private TokenResponseProcessor(TokenResponseConfiguration tokenResponseConfiguration, ExpressionManager expressionManager, boolean retrieveRefreshToken) {
        this.tokenResponseConfiguration = tokenResponseConfiguration;
        this.expressionManager = expressionManager;
        this.retrieveRefreshToken = retrieveRefreshToken;
    }

    public void process(MuleEvent muleEvent) {
        this.accessToken = this.expressionManager.parse(this.tokenResponseConfiguration.getAccessToken(), muleEvent);
        if (this.retrieveRefreshToken) {
            this.refreshToken = this.expressionManager.parse(this.tokenResponseConfiguration.getRefreshToken(), muleEvent);
        }
        this.expiresIn = this.expressionManager.parse(this.tokenResponseConfiguration.getExpiresIn(), muleEvent);
        this.customResponseParameters = new HashMap<String, Object>();
        for (ParameterExtractor parameterExtractor : this.tokenResponseConfiguration.getParameterExtractors()) {
            this.customResponseParameters.put(parameterExtractor.getParamName(), this.expressionManager.evaluate(parameterExtractor.getValue(), muleEvent));
        }
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getExpiresIn() {
        return this.expiresIn;
    }

    public Map<String, Object> getCustomResponseParameters() {
        return this.customResponseParameters;
    }
}

