/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.mbean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MessageExchangePattern;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.management.mbean.EndpointServiceMBean;
import org.mule.util.ObjectNameHelper;

public class EndpointService
implements EndpointServiceMBean {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private ImmutableEndpoint endpoint;
    private MessageReceiver receiver;
    private String name;
    private String componentName;

    public EndpointService(ImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        this.init();
    }

    public EndpointService(MessageReceiver receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull((String)"Receiver").getMessage());
        }
        this.endpoint = receiver.getEndpoint();
        this.receiver = receiver;
        this.componentName = receiver.getFlowConstruct().getName();
        this.init();
    }

    private void init() {
        if (this.endpoint == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull((String)"Endpoint").getMessage());
        }
        if (this.receiver == null && this.endpoint instanceof InboundEndpoint) {
            throw new IllegalArgumentException("Recevier is null for Endpoint MBean but the endpoint itself is a receiving endpoint");
        }
        this.name = new ObjectNameHelper(this.endpoint.getConnector().getMuleContext()).getEndpointName(this.endpoint.getEndpointURI());
    }

    @Override
    public String getAddress() {
        return this.endpoint.getEndpointURI().getAddress();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isConnected() {
        return this.receiver == null || this.receiver.isConnected();
    }

    @Override
    public void connect() throws Exception {
        if (this.receiver != null && !this.receiver.isConnected()) {
            this.receiver.connect();
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Endpoint is already connected");
        }
    }

    @Override
    public void disconnect() throws Exception {
        if (this.receiver != null && this.receiver.isConnected()) {
            this.receiver.disconnect();
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Endpoint is already disconnected");
        }
    }

    @Override
    public boolean isInbound() {
        return this.endpoint instanceof InboundEndpoint;
    }

    @Override
    public boolean isOutbound() {
        return this.endpoint instanceof OutboundEndpoint;
    }

    @Override
    public MessageExchangePattern getMessageExchangePattern() {
        return this.endpoint.getExchangePattern();
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }
}

