/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.mbeans;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.impl.model.AbstractComponent;
import org.mule.impl.model.seda.SedaComponent;
import org.mule.management.mbeans.ComponentServiceMBean;
import org.mule.management.mbeans.ComponentStats;
import org.mule.management.mbeans.ComponentStatsMBean;
import org.mule.management.stats.ComponentStatistics;
import org.mule.umo.UMOException;
import org.mule.umo.UMOSession;

public class ComponentService
implements ComponentServiceMBean,
MBeanRegistration,
ComponentStatsMBean {
    private static transient Log LOGGER = LogFactory.getLog((Class)ComponentService.class);
    private MBeanServer server;
    private String name;
    private ObjectName statsName;
    private ObjectName objectName;
    private ComponentStatistics statistics;

    public ComponentService(String name) {
        this.name = name;
        this.statistics = this.getComponent().getStatistics();
    }

    public int getQueueSize() {
        AbstractComponent c = this.getComponent();
        if (c instanceof SedaComponent) {
            return ((SedaComponent)c).getQueueSize();
        }
        return -1;
    }

    public void pause() throws UMOException {
        this.getComponent().pause();
    }

    public void resume() throws UMOException {
        this.getComponent().resume();
    }

    public boolean isPaused() {
        return this.getComponent().isPaused();
    }

    public boolean isStopped() {
        return this.getComponent().isStopped();
    }

    public void stop() throws UMOException {
        this.getComponent().stop();
    }

    public void forceStop() throws UMOException {
        this.getComponent().forceStop();
    }

    public boolean isStopping() {
        return this.getComponent().isStopping();
    }

    public void dispose() throws UMOException {
        this.getComponent().dispose();
    }

    public void start() throws UMOException {
        this.getComponent().start();
    }

    public ObjectName getStatistics() {
        return this.statsName;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.objectName = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        try {
            if (this.getComponent().getStatistics() != null) {
                this.statsName = new ObjectName(this.objectName.getDomain() + ":type=org.mule.Statistics,component=" + this.getName());
                if (this.server.isRegistered(this.statsName)) {
                    this.server.unregisterMBean(this.statsName);
                }
                this.server.registerMBean(new ComponentStats(this.getComponent().getStatistics()), this.statsName);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error post-registering the MBean", (Throwable)e);
        }
    }

    public void preDeregister() throws Exception {
        try {
            if (this.server.isRegistered(this.statsName)) {
                this.server.unregisterMBean(this.statsName);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error unregistering ComponentService child " + this.statsName.getCanonicalName()), (Throwable)ex);
        }
    }

    public void postDeregister() {
    }

    private AbstractComponent getComponent() {
        UMOSession session = MuleManager.getInstance().getModel().getComponentSession(this.getName());
        if (session == null) {
            return null;
        }
        return (AbstractComponent)session.getComponent();
    }

    public void clearStatistics() {
        this.statistics.clear();
    }

    public long getAsyncEventsReceived() {
        return this.statistics.getAsyncEventsReceived();
    }

    public long getAsyncEventsSent() {
        return this.statistics.getAsyncEventsSent();
    }

    public long getAverageExecutionTime() {
        return this.statistics.getAverageExecutionTime();
    }

    public long getAverageQueueSize() {
        return this.statistics.getAverageQueueSize();
    }

    public long getExecutedEvents() {
        return this.statistics.getExecutedEvents();
    }

    public long getExecutionErrors() {
        return this.statistics.getExecutionErrors();
    }

    public long getFatalErrors() {
        return this.statistics.getFatalErrors();
    }

    public long getMaxExecutionTime() {
        return this.statistics.getMaxExecutionTime();
    }

    public long getMaxQueueSize() {
        return this.statistics.getMaxQueueSize();
    }

    public long getMinExecutionTime() {
        return this.statistics.getMinExecutionTime();
    }

    public String getName() {
        return this.name;
    }

    public long getQueuedEvents() {
        return this.statistics.getQueuedEvents();
    }

    public long getReplyToEventsSent() {
        return this.statistics.getReplyToEventsSent();
    }

    public long getSyncEventsReceived() {
        return this.statistics.getSyncEventsReceived();
    }

    public long getSyncEventsSent() {
        return this.statistics.getSyncEventsSent();
    }

    public long getTotalEventsReceived() {
        return this.statistics.getTotalEventsReceived();
    }

    public long getTotalEventsSent() {
        return this.statistics.getTotalEventsSent();
    }

    public long getTotalExecutionTime() {
        return this.statistics.getTotalExecutionTime();
    }
}

