/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import mx4j.log.CommonsLogger;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.adaptor.AdaptorServerSocketFactory;
import mx4j.tools.adaptor.http.HttpAdaptor;
import mx4j.tools.adaptor.http.ProcessorMBean;
import mx4j.tools.adaptor.http.XSLTProcessor;
import mx4j.tools.adaptor.ssl.SSLAdaptorServerSocketFactory;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.management.agents.IBMSslAdapterServerSocketFactory;
import org.mule.management.agents.JmxManagementException;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.util.BeanUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;

public class Mx4jAgent
implements UMOAgent {
    public static final String HTTP_ADAPTER_OBJECT_NAME = "Mule:name=Mx4jHttpAdapter";
    private static final org.apache.commons.logging.Log logger = LogFactory.getLog((Class)Mx4jAgent.class);
    private String name = "MX4J Agent";
    private String jmxAdaptorUrl = "http://localhost:9999";
    private HttpAdaptor adaptor;
    private MBeanServer mBeanServer;
    private ObjectName adaptorName;
    private String login = null;
    private String password = null;
    private String authenticationMethod = "basic";
    private String xslFilePath = null;
    private String pathInJar = null;
    private boolean cacheXsl = true;
    private Map socketFactoryProperties = new HashMap();

    protected HttpAdaptor createAdaptor() throws Exception {
        Log.redirectTo((Logger)new CommonsLogger());
        URI uri = new URI(StringUtils.stripToEmpty((String)this.jmxAdaptorUrl));
        this.adaptor = new HttpAdaptor(uri.getPort(), uri.getHost());
        XSLTProcessor processor = new XSLTProcessor();
        if (StringUtils.isNotBlank((String)this.xslFilePath)) {
            processor.setFile(this.xslFilePath.trim());
        }
        if (StringUtils.isNotBlank((String)this.pathInJar)) {
            processor.setPathInJar(this.pathInJar.trim());
        }
        processor.setUseCache(this.cacheXsl);
        this.adaptor.setProcessor((ProcessorMBean)processor);
        if (this.login != null) {
            this.adaptor.addAuthorization(this.login, this.password);
            this.adaptor.setAuthenticationMethod(this.authenticationMethod);
        }
        if (this.socketFactoryProperties != null && !this.socketFactoryProperties.isEmpty()) {
            IBMSslAdapterServerSocketFactory factory = SystemUtils.isIbmJDK() ? new IBMSslAdapterServerSocketFactory() : new SSLAdaptorServerSocketFactory();
            BeanUtils.populateWithoutFail((Object)factory, (Map)this.socketFactoryProperties, (boolean)true);
            this.adaptor.setSocketFactory((AdaptorServerSocketFactory)factory);
        }
        return this.adaptor;
    }

    public void initialise() throws InitialisationException {
        try {
            this.mBeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
            this.adaptor = this.createAdaptor();
            this.adaptorName = new ObjectName(HTTP_ADAPTER_OBJECT_NAME);
            this.unregisterMBeansIfNecessary();
            this.mBeanServer.registerMBean(this.adaptor, this.adaptorName);
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(42, (Object)"mx4j agent"), (Throwable)e, (Object)this);
        }
    }

    public void start() throws UMOException {
        try {
            this.mBeanServer.invoke(this.adaptorName, "start", null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new JmxManagementException(new Message(42, (Object)"Mx4j agent"), this.adaptorName, e);
        }
        catch (MBeanException e) {
            throw new JmxManagementException(new Message(42, (Object)"Mx4j agent"), this.adaptorName, e);
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public void stop() throws UMOException {
        try {
            this.mBeanServer.invoke(this.adaptorName, "stop", null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new JmxManagementException(new Message(41, (Object)"Mx4j agent"), this.adaptorName, e);
        }
        catch (MBeanException e) {
            throw new JmxManagementException(new Message(41, (Object)"Mx4j agent"), this.adaptorName, e);
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    protected void unregisterMBeansIfNecessary() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        if (this.mBeanServer.isRegistered(ObjectName.getInstance(HTTP_ADAPTER_OBJECT_NAME))) {
            this.mBeanServer.unregisterMBean(this.adaptorName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void dispose() {
        block8: {
            this.stop();
            Object var3_1 = null;
            try {
                this.unregisterMBeansIfNecessary();
            }
            catch (Exception e2) {
                logger.error((Object)("Couldn't unregister MBean: " + (this.adaptorName != null ? this.adaptorName.getCanonicalName() : "null")), (Throwable)e2);
            }
            break block8;
            {
                catch (Exception e) {
                    logger.warn((Object)("Failed to stop Mx4jAgent: " + e.getMessage()));
                    Object var3_2 = null;
                    try {
                        this.unregisterMBeansIfNecessary();
                    }
                    catch (Exception e2) {
                        logger.error((Object)("Couldn't unregister MBean: " + (this.adaptorName != null ? this.adaptorName.getCanonicalName() : "null")), (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.unregisterMBeansIfNecessary();
                }
                catch (Exception e2) {
                    logger.error((Object)("Couldn't unregister MBean: " + (this.adaptorName != null ? this.adaptorName.getCanonicalName() : "null")), (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public String getDescription() {
        return "MX4J Http adaptor: " + this.jmxAdaptorUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getJmxAdaptorUrl() {
        return this.jmxAdaptorUrl;
    }

    public void setJmxAdaptorUrl(String jmxAdaptorUrl) {
        this.jmxAdaptorUrl = jmxAdaptorUrl;
    }

    public Map getSocketFactoryProperties() {
        return this.socketFactoryProperties;
    }

    public void setSocketFactoryProperties(Map socketFactoryProperties) {
        this.socketFactoryProperties = socketFactoryProperties;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public String getXslFilePath() {
        return this.xslFilePath;
    }

    public void setXslFilePath(String xslFilePath) {
        this.xslFilePath = xslFilePath;
    }

    public String getPathInJar() {
        return this.pathInJar;
    }

    public void setPathInJar(String pathInJar) {
        this.pathInJar = pathInJar;
    }

    public boolean isCacheXsl() {
        return this.cacheXsl;
    }

    public void setCacheXsl(boolean cacheXsl) {
        this.cacheXsl = cacheXsl;
    }
}

