/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.internal.admin.AbstractNotificationLoggerAgent;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOServerNotification;

public class JmxServerNotificationAgent
extends AbstractNotificationLoggerAgent {
    public static final String LISTENER_JMX_OBJECT_NAME = "type=org.mule.Notification,name=MuleNotificationListener";
    public static final String BROADCASTER_JMX_OBJECT_NAME = "type=org.mule.Notification,name=MuleNotificationBroadcaster";
    private MBeanServer mBeanServer;
    private BroadcastNotificationService broadcastNotificationMbean;
    private boolean useInstanceIdAsDomain = true;
    private boolean registerListenerMbean = true;
    private ObjectName listenerObjectName;
    private ObjectName broadcasterObjectName;

    protected void doInitialise() throws InitialisationException {
        if (this.getName() == null) {
            this.setName("Jmx Notification Agent");
        }
        try {
            this.mBeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
            this.broadcasterObjectName = ObjectName.getInstance(this.getDomainName() + ":" + BROADCASTER_JMX_OBJECT_NAME);
            this.broadcastNotificationMbean = new BroadcastNotificationService();
            this.mBeanServer.registerMBean(this.broadcastNotificationMbean, this.broadcasterObjectName);
            if (this.registerListenerMbean) {
                this.listenerObjectName = ObjectName.getInstance(this.getDomainName() + ":" + LISTENER_JMX_OBJECT_NAME);
                NotificationListener mbean = new NotificationListener();
                this.broadcastNotificationMbean.addNotificationListener(mbean, null, null);
                this.mBeanServer.registerMBean(mbean, this.listenerObjectName);
            }
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(42, (Object)"JMX Server Notification Agent"), (Throwable)e, (Object)this);
        }
    }

    public void dispose() {
        try {
            if (this.listenerObjectName != null) {
                this.mBeanServer.unregisterMBean(this.listenerObjectName);
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.mBeanServer.unregisterMBean(this.broadcasterObjectName);
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        super.dispose();
    }

    protected void logEvent(UMOServerNotification e) {
        this.broadcastNotificationMbean.sendNotification(new Notification(e.getClass().getName(), (Object)e, e.getTimestamp(), e.toString()));
    }

    public String getDescription() {
        return "Jmx Notification Agent" + (this.registerListenerMbean ? "(Listener MBean registered)" : "");
    }

    protected String getDomainName() {
        if (MuleManager.getInstance().getId() != null && this.isUseInstanceIdAsDomain()) {
            return MuleManager.getInstance().getId();
        }
        return "org.mule";
    }

    public boolean isUseInstanceIdAsDomain() {
        return this.useInstanceIdAsDomain;
    }

    public void setUseInstanceIdAsDomain(boolean useInstanceIdAsDomain) {
        this.useInstanceIdAsDomain = useInstanceIdAsDomain;
    }

    public static class NotificationListener
    implements NotificationListenerMBean,
    javax.management.NotificationListener {
        private int listSize = 100;
        private List notifs;

        public void handleNotification(Notification notification, Object o) {
            if (this.getList().size() == this.listSize) {
                this.getList().remove(this.listSize - 1);
            }
            this.getList().add(0, notification);
        }

        public List getNotificsationList() {
            return this.notifs;
        }

        public int getListSize() {
            return this.listSize;
        }

        public void setListSize(int listSize) {
            this.listSize = listSize;
        }

        protected List getList() {
            if (this.notifs == null) {
                this.notifs = new ArrayList(this.listSize);
            }
            return this.notifs;
        }
    }

    public static interface NotificationListenerMBean {
        public List getNotificsationList();

        public int getListSize();

        public void setListSize(int var1);
    }

    public static class BroadcastNotificationService
    extends NotificationBroadcasterSupport
    implements BroadcastNotificationServiceMBean {
    }

    public static interface BroadcastNotificationServiceMBean
    extends NotificationEmitter {
    }
}

