/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import java.util.HashMap;
import org.mule.MuleManager;
import org.mule.management.agents.JdmkAgent;
import org.mule.management.agents.JmxAgent;
import org.mule.management.agents.JmxServerNotificationAgent;
import org.mule.management.agents.Log4jAgent;
import org.mule.management.agents.Mx4jAgent;
import org.mule.management.agents.RmiRegistryAgent;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.RecoverableException;
import org.mule.umo.manager.UMOAgent;

public class DefaultJmxSupportAgent
implements UMOAgent {
    public static final String DEFAULT_REMOTING_URI = "service:jmx:rmi:///jndi/rmi://localhost:1099/server";
    private String name = "Default Jmx";
    private boolean loadJmdkAgent = false;
    private boolean loadMX4JAgent = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return "Default Jmx Agent Support";
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void start() throws UMOException {
    }

    public void stop() throws UMOException {
    }

    public void dispose() {
    }

    public void initialise() throws InitialisationException, RecoverableException {
        try {
            Object agent = this.createRmiAgent();
            if (!this.isAgentRegistered((UMOAgent)agent)) {
                MuleManager.getInstance().registerAgent((UMOAgent)agent);
            }
            if (!this.isAgentRegistered((UMOAgent)(agent = this.createJmxAgent()))) {
                MuleManager.getInstance().registerAgent((UMOAgent)agent);
            }
            if (!this.isAgentRegistered((UMOAgent)(agent = this.createLog4jAgent()))) {
                MuleManager.getInstance().registerAgent((UMOAgent)agent);
            }
            if (!this.isAgentRegistered((UMOAgent)(agent = this.createJmxNotificationAgent()))) {
                MuleManager.getInstance().registerAgent((UMOAgent)agent);
            }
            if (this.loadJmdkAgent && !this.isAgentRegistered((UMOAgent)(agent = this.createJdmkAgent()))) {
                MuleManager.getInstance().registerAgent((UMOAgent)agent);
            }
            if (this.loadMX4JAgent && !this.isAgentRegistered((UMOAgent)(agent = this.createMx4jAgent()))) {
                MuleManager.getInstance().registerAgent((UMOAgent)agent);
            }
            MuleManager.getInstance().unregisterAgent(this.name);
        }
        catch (UMOException e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
    }

    protected JmxAgent createJmxAgent() {
        JmxAgent agent = new JmxAgent();
        agent.setConnectorServerUrl(DEFAULT_REMOTING_URI);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("jmx.remote.jndi.rebind", "true");
        agent.setConnectorServerProperties(props);
        return agent;
    }

    protected Log4jAgent createLog4jAgent() {
        return new Log4jAgent();
    }

    protected RmiRegistryAgent createRmiAgent() {
        return new RmiRegistryAgent();
    }

    protected JmxServerNotificationAgent createJmxNotificationAgent() {
        return new JmxServerNotificationAgent();
    }

    protected Mx4jAgent createMx4jAgent() {
        return new Mx4jAgent();
    }

    protected JdmkAgent createJdmkAgent() {
        return new JdmkAgent();
    }

    protected boolean isAgentRegistered(UMOAgent agent) {
        return MuleManager.getInstance().lookupAgent(agent.getName()) != null;
    }

    public boolean isLoadJmdkAgent() {
        return this.loadJmdkAgent;
    }

    public void setLoadJmdkAgent(boolean loadJmdkAgent) {
        this.loadJmdkAgent = loadJmdkAgent;
    }

    public boolean isLoadMX4JAgent() {
        return this.loadMX4JAgent;
    }

    public void setLoadMX4JAgent(boolean loadMX4JAgent) {
        this.loadMX4JAgent = loadMX4JAgent;
    }
}

