/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.logging;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.LogManager;
import org.mule.module.logging.AccessibleLog4jLoggerAdapter;
import org.mule.module.logging.DispatchingLogger;
import org.mule.module.logging.LoggerReferenceHandler;
import org.mule.module.logging.MuleUtils;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class MuleLoggerFactory
implements ILoggerFactory {
    public static final String LOG_HANDLER_THREAD_NAME = "Mule.log.slf4j.ref.handler";
    protected static final Integer NO_CCL_CLASSLOADER = 0;
    protected ConcurrentMap<Integer, ConcurrentMap<String, Logger>> repository = new ConcurrentHashMap<Integer, ConcurrentMap<String, Logger>>();
    protected ReferenceQueue<ClassLoader> referenceQueue = new ReferenceQueue();
    protected Map<PhantomReference<ClassLoader>, Integer> refs = new HashMap<PhantomReference<ClassLoader>, Integer>();

    public MuleLoggerFactory() {
        if (MuleUtils.isStandalone()) {
            this.createLoggerReferenceHandler();
        }
    }

    protected void createLoggerReferenceHandler() {
        new LoggerReferenceHandler(LOG_HANDLER_THREAD_NAME, this.referenceQueue, this.refs, this.repository);
    }

    @Override
    public Logger getLogger(String name) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        return this.getLogger(name, ccl);
    }

    public Logger getLogger(String name, ClassLoader classLoader) {
        org.apache.log4j.Logger log4jLogger;
        Logger previous;
        Logger slf4jLogger;
        ConcurrentMap<String, Logger> loggerMap = (ConcurrentHashMap)this.repository.get(classLoader == null ? NO_CCL_CLASSLOADER.intValue() : classLoader.hashCode());
        if (loggerMap == null) {
            loggerMap = new ConcurrentHashMap();
            ConcurrentMap previous2 = this.repository.putIfAbsent(classLoader == null ? NO_CCL_CLASSLOADER.intValue() : classLoader.hashCode(), loggerMap);
            if (previous2 != null) {
                loggerMap = previous2;
            }
            if (classLoader != null) {
                this.refs.put(new PhantomReference<ClassLoader>(classLoader, this.referenceQueue), classLoader.hashCode());
            }
        }
        if ((slf4jLogger = (Logger)loggerMap.get(name)) == null && (previous = loggerMap.putIfAbsent(name, slf4jLogger = new DispatchingLogger(new AccessibleLog4jLoggerAdapter(log4jLogger = name.equalsIgnoreCase("ROOT") ? LogManager.getRootLogger() : LogManager.getLogger((String)name)), this))) != null) {
            slf4jLogger = previous;
        }
        return slf4jLogger;
    }
}

