/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentListenerManager;

public class CompositeDeploymentListener
implements DeploymentListener,
DeploymentListenerManager {
    private final transient Log logger = LogFactory.getLog(this.getClass());
    private List<DeploymentListener> deploymentListeners = new CopyOnWriteArrayList<DeploymentListener>();

    @Override
    public void addDeploymentListener(DeploymentListener listener) {
        this.deploymentListeners.add(listener);
    }

    @Override
    public void removeDeploymentListener(DeploymentListener listener) {
        this.deploymentListeners.remove(listener);
    }

    @Override
    public void onDeploymentStart(String appName) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onDeploymentStart(appName);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(appName, listener, "onDeploymentStart", t);
            }
        }
    }

    @Override
    public void onDeploymentSuccess(String appName) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onDeploymentSuccess(appName);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(appName, listener, "onDeploymentSuccess", t);
            }
        }
    }

    @Override
    public void onDeploymentFailure(String appName, Throwable cause) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onDeploymentFailure(appName, cause);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(appName, listener, "onDeploymentFailure", t);
            }
        }
    }

    @Override
    public void onUndeploymentStart(String appName) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onUndeploymentStart(appName);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(appName, listener, "onUndeploymentStart", t);
            }
        }
    }

    @Override
    public void onUndeploymentSuccess(String appName) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onUndeploymentSuccess(appName);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(appName, listener, "onUndeploymentSuccess", t);
            }
        }
    }

    @Override
    public void onUndeploymentFailure(String appName, Throwable cause) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onUndeploymentFailure(appName, cause);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(appName, listener, "onUndeploymentFailure", t);
            }
        }
    }

    @Override
    public void onMuleContextCreated(String appName, MuleContext context) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onMuleContextCreated(appName, context);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(appName, listener, "onMuleContextCreated", t);
            }
        }
    }

    @Override
    public void onMuleContextInitialised(String appName, MuleContext context) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onMuleContextInitialised(appName, context);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(appName, listener, "onMuleContextInitialised", t);
            }
        }
    }

    @Override
    public void onMuleContextConfigured(String appName, MuleContext context) {
        for (DeploymentListener listener : this.deploymentListeners) {
            try {
                listener.onMuleContextConfigured(appName, context);
            }
            catch (Throwable t) {
                this.logNotificationProcessingError(appName, listener, "onMuleContextConfigured", t);
            }
        }
    }

    private void logNotificationProcessingError(String appName, DeploymentListener listener, String notification, Throwable error) {
        this.logger.error((Object)String.format("Listener '%s' failed to process notification '%s' for application '%s'", listener, notification, appName), error);
    }
}

