/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.transformers;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.json.transformers.JsonSchemaFilter;
import org.mule.module.json.transformers.JsonToXml;
import org.mule.module.json.transformers.TransformerInputs;
import org.mule.module.xml.filters.SchemaValidationFilter;
import org.mule.util.IOUtils;

public class JsonSchemaXsdValidationFilter
extends SchemaValidationFilter
implements JsonSchemaFilter {
    protected MuleContext muleContext;
    protected JsonToXml jToX;

    public boolean accept(MuleMessage msg) {
        String jsonString = null;
        try {
            if (this.isReturnResult()) {
                TransformerInputs transformerInputs = new TransformerInputs(null, msg.getPayload());
                StringWriter jsonWriter = new StringWriter();
                if (transformerInputs.getInputStream() != null) {
                    jsonWriter = new StringWriter();
                    IOUtils.copy((InputStream)transformerInputs.getInputStream(), (Writer)jsonWriter, (String)msg.getEncoding());
                } else {
                    IOUtils.copy((Reader)transformerInputs.getReader(), (Writer)jsonWriter);
                }
                jsonString = ((Object)jsonWriter).toString();
                msg.setPayload((Object)jsonString);
            }
            String xmlString = (String)this.jToX.transform(msg.getPayload(), msg.getEncoding());
            DefaultMuleMessage xmlMessage = new DefaultMuleMessage((Object)xmlString, msg, msg.getMuleContext());
            boolean accepted = super.accept((MuleMessage)xmlMessage);
            if (jsonString != null) {
                msg.setPayload((Object)jsonString);
            }
            return accepted;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        this.jToX = new JsonToXml();
        this.jToX.setMuleContext(this.muleContext);
    }

    @Override
    public void setSchemaLocations(String schemaLocations) {
        super.setSchemaLocations(schemaLocations);
    }
}

