/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.transformers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import org.apache.commons.beanutils.DynaBean;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.message.DefaultMuleMessageDTO;
import org.mule.module.json.util.JsonUtils;
import org.mule.transformer.AbstractTransformer;

public class JsonToObject
extends AbstractTransformer {
    protected JsonConfig jsonConfig;
    protected Map dtoMappings;

    public JsonToObject() {
        this.registerSourceType(JSONObject.class);
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.setReturnClass(Object.class);
        this.dtoMappings = new HashMap(1);
        this.dtoMappings.put("payload", HashMap.class);
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.getReturnClass().equals(Object.class)) {
            this.logger.warn((Object)"The return class is not set not type validation will be done");
        }
        if (this.getReturnClass().isArray()) {
            this.getJsonConfig().setEnclosedType(this.getReturnClass());
            this.getJsonConfig().setArrayMode(2);
        } else if (List.class.isAssignableFrom(this.getReturnClass())) {
            this.getJsonConfig().setEnclosedType(this.getReturnClass());
            this.getJsonConfig().setArrayMode(1);
        } else if (Set.class.isAssignableFrom(this.getReturnClass())) {
            this.getJsonConfig().setEnclosedType(this.getReturnClass());
            this.getJsonConfig().setArrayMode(2);
        }
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            Object returnValue = null;
            if (src instanceof byte[]) {
                src = new String((byte[])src, encoding);
            }
            if (src instanceof String) {
                if (this.getReturnClass().equals(DynaBean.class)) {
                    JSON json = JSONSerializer.toJSON((Object)src.toString(), (JsonConfig)this.getJsonConfig());
                    returnValue = JSONObject.toBean((JSONObject)((JSONObject)json), (JsonConfig)this.getJsonConfig());
                } else {
                    returnValue = JsonUtils.convertJsonToBean((String)src, this.getJsonConfig(), this.getReturnClass(), this.getReturnClass().equals(DefaultMuleMessageDTO.class) ? this.dtoMappings : null);
                }
            } else if (src instanceof JSONObject) {
                returnValue = JSONObject.toBean((JSONObject)((JSONObject)src), (Class)this.getReturnClass(), new HashMap());
            }
            return returnValue;
        }
        catch (Exception e) {
            throw new TransformerException(CoreMessages.transformFailed((String)"json", (String)this.getReturnClass().getName()), (Transformer)this, (Throwable)e);
        }
    }

    public JsonConfig getJsonConfig() {
        if (this.jsonConfig == null) {
            this.setJsonConfig(new JsonConfig());
        }
        return this.jsonConfig;
    }

    public void setJsonConfig(JsonConfig jsonConfig) {
        this.jsonConfig = jsonConfig;
    }
}

