/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.WebApplicationFactory;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.component.JavaComponent;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.TransformerException;
import org.mule.component.AbstractComponent;
import org.mule.module.jersey.MuleComponentProviderFactory;
import org.mule.module.jersey.MuleResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JerseyResourcesComponent
extends AbstractComponent {
    public static String JERSEY_RESPONSE = "jersey_response";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private List<JavaComponent> components;
    private WebApplication application;
    private List<ExceptionMapper<?>> exceptionMappers = new ArrayList();

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        HashSet resources = new HashSet();
        if (this.components == null) {
            throw new IllegalStateException("There must be at least one component in the Jersey resources.");
        }
        this.initializeResources(resources);
        this.initializeExceptionMappers(resources);
        DefaultResourceConfig resourceConfig = this.createConfiguration(resources);
        this.application = WebApplicationFactory.createWebApplication();
        this.application.initiate((ResourceConfig)resourceConfig, this.getComponentProvider());
    }

    protected void initializeResources(Set<Class<?>> resources) throws InitialisationException {
        for (JavaComponent component : this.components) {
            try {
                Class c = component.getObjectType();
                resources.add(c);
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    protected void initializeExceptionMappers(Set<Class<?>> resources) {
        for (ExceptionMapper<?> exceptionMapper : this.exceptionMappers) {
            resources.add(exceptionMapper.getClass());
        }
    }

    protected DefaultResourceConfig createConfiguration(Set<Class<?>> resources) {
        return new DefaultResourceConfig(resources);
    }

    protected Object doInvoke(MuleEvent event) throws Exception {
        MuleMessage message = event.getMessage();
        String path = (String)message.getInboundProperty("http.request");
        String contextPath = (String)message.getInboundProperty("http.context.path");
        String query = null;
        int queryIdx = path.indexOf(63);
        if (queryIdx != -1) {
            query = path.substring(queryIdx + 1);
            path = path.substring(0, queryIdx);
        }
        EndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        String host = (String)message.getInboundProperty("Host", (Object)endpointUri.getHost());
        String method = (String)message.getInboundProperty("http.method");
        InBoundHeaders headers = new InBoundHeaders();
        for (String prop : message.getInboundPropertyNames()) {
            Object property = message.getInboundProperty(prop.toString());
            if (property == null) continue;
            headers.add(prop.toString(), (Object)property.toString());
        }
        String scheme = "servlet".equals(endpointUri.getScheme()) ? "http" : endpointUri.getScheme();
        URI baseUri = JerseyResourcesComponent.getBaseUri(endpointUri, scheme, host, contextPath);
        URI completeUri = JerseyResourcesComponent.getCompleteUri(endpointUri, scheme, host, path, query);
        ContainerRequest req = new ContainerRequest(this.application, method, baseUri, completeUri, headers, JerseyResourcesComponent.getInputStream(message));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Base URI: " + baseUri));
            this.logger.debug((Object)("Complete URI: " + completeUri));
        }
        MuleResponseWriter writer = new MuleResponseWriter(message);
        ContainerResponse res = new ContainerResponse(this.application, req, (ContainerResponseWriter)writer);
        this.application.handleRequest(req, res);
        return writer.getResponse();
    }

    protected static InputStream getInputStream(MuleMessage message) throws TransformerException {
        return (InputStream)message.getPayload(InputStream.class);
    }

    protected IoCComponentProviderFactory getComponentProvider() {
        return new MuleComponentProviderFactory(this.muleContext, this.components);
    }

    protected static URI getCompleteUri(EndpointURI endpointUri, String scheme, String host, String path, String query) throws URISyntaxException {
        String uri = scheme + "://" + host + path;
        if (query != null) {
            uri = uri + "?" + query;
        }
        return new URI(uri);
    }

    protected static URI getBaseUri(EndpointURI endpointUri, String scheme, String host, String contextPath) throws URISyntaxException {
        if (!contextPath.endsWith("/")) {
            contextPath = contextPath + "/";
        }
        return new URI(scheme + "://" + host + contextPath);
    }

    public List<JavaComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<JavaComponent> components) {
        this.components = components;
    }

    public void setMessageProcessors(List<MessageProcessor> messageProcessors) {
        ArrayList<JavaComponent> javaComponents = new ArrayList<JavaComponent>();
        for (MessageProcessor mp : messageProcessors) {
            if (mp instanceof JavaComponent) {
                javaComponents.add((JavaComponent)mp);
                continue;
            }
            throw new IllegalStateException("Only JavaComponents are allowed as MessageProcessors. Type " + mp.getClass().getName() + " is not allowed.");
        }
        this.setComponents(javaComponents);
    }

    public void setExceptionMapper(ExceptionMapper<?> exceptionMapper) {
        this.exceptionMappers.add(exceptionMapper);
    }
}

