/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jbpm;

import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.internal.log.Log;
import org.jbpm.jpdl.internal.activity.StateActivity;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.mule.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleReceiveActivity
extends StateActivity {
    private String endpoint;
    private Class payloadClass;
    private String variableName;
    private final boolean startState;
    private static final Log log = Log.getLog((String)MuleReceiveActivity.class.getName());

    public MuleReceiveActivity(boolean startState) {
        this.startState = startState;
    }

    public void execute(ExecutionImpl execution) {
        execution.historyActivityStart();
        if (this.startState) {
            execution.signal();
        } else {
            execution.waitForSignal();
        }
    }

    public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
        Object payload = execution.getVariable("incoming");
        if (this.endpoint != null) {
            String messageSource = (String)execution.getVariable("incomingSource");
            log.debug("Validating message source = " + messageSource + ", expected = " + this.endpoint);
            if (!this.endpoint.equalsIgnoreCase(messageSource)) {
                throw new JbpmException("Incoming message source is " + messageSource + " but expected source is " + this.endpoint);
            }
        }
        if (this.payloadClass != null) {
            log.debug("Validating message type = " + payload.getClass() + ", expected = " + this.payloadClass);
            if (!this.payloadClass.isAssignableFrom(payload.getClass())) {
                throw new JbpmException("Incoming message is of type " + payload.getClass() + " but expected type is " + this.payloadClass);
            }
        }
        if (this.variableName != null) {
            if (payload != null) {
                log.debug("Storing incoming message to variable " + this.variableName + ", payload = " + payload);
                execution.setVariable(this.variableName, payload);
            } else {
                log.info("Synchronous message was sent to endpoint " + this.endpoint + ", but no response was returned.");
            }
        }
        super.signal(execution, signalName, parameters);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public void setPayloadClass(String className) {
        if (className != null) {
            try {
                this.payloadClass = ClassUtils.loadClass((String)className, ((Object)((Object)this)).getClass());
            }
            catch (ClassNotFoundException e) {
                log.error("Expected message type not valid: " + e.getMessage());
            }
        }
    }

    public Class getPayloadClass() {
        return this.payloadClass;
    }
}

