/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.listener;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.http.internal.HttpMessageParsingException;
import org.mule.runtime.module.http.internal.listener.HttpMessagePropertiesResolver;
import org.mule.runtime.module.http.internal.listener.ListenerPath;
import org.mule.runtime.module.http.internal.multipart.HttpPartDataSource;
import org.mule.runtime.module.http.internal.util.HttpToMuleMessage;
import org.mule.service.http.api.HttpHeaders;
import org.mule.service.http.api.domain.entity.EmptyHttpEntity;
import org.mule.service.http.api.domain.entity.HttpEntity;
import org.mule.service.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.service.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.service.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.api.domain.request.HttpRequestContext;
import org.mule.service.http.api.utils.HttpEncoderDecoderUtils;

public class HttpRequestToMuleEvent {
    public static InternalMessage transform(HttpRequestContext requestContext, Charset charset, Boolean parseRequest, ListenerPath listenerPath) throws HttpMessageParsingException {
        HttpRequest request = requestContext.getRequest();
        Collection headerNames = request.getHeaderNames();
        HashMap<String, Serializable> inboundProperties = new HashMap<String, Serializable>();
        HashMap outboundProperties = new HashMap();
        for (String headerName : headerNames) {
            if ("Content-Type".equalsIgnoreCase(headerName)) continue;
            Collection values = request.getHeaderValues(headerName);
            if (values.size() == 1) {
                inboundProperties.put(headerName, (Serializable)values.iterator().next());
                continue;
            }
            inboundProperties.put(headerName, new ArrayList(values));
        }
        new HttpMessagePropertiesResolver().setMethod(request.getMethod()).setProtocol(request.getProtocol().asString()).setUri(request.getUri()).setListenerPath(listenerPath).setRemoteHostAddress(HttpRequestToMuleEvent.resolveRemoteHostAddress(requestContext)).setScheme(requestContext.getScheme()).setClientCertificate(requestContext.getClientConnection().getClientCertificate()).addPropertiesTo(inboundProperties);
        InputStream payload = null;
        MediaType mediaType = HttpToMuleMessage.getMediaType(request.getHeaderValueIgnoreCase("Content-Type"), charset);
        if (parseRequest.booleanValue()) {
            HttpEntity entity = request.getEntity();
            if (entity != null && !(entity instanceof EmptyHttpEntity)) {
                if (entity instanceof MultipartHttpEntity) {
                    try {
                        payload = HttpPartDataSource.multiPartPayloadForAttachments((MultipartHttpEntity)entity);
                    }
                    catch (IOException e) {
                        throw new HttpMessageParsingException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), e);
                    }
                } else if (mediaType != null) {
                    if (mediaType.matches(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED)) {
                        try {
                            payload = HttpEncoderDecoderUtils.decodeUrlEncodedBody((String)IOUtils.toString((InputStream)((InputStreamHttpEntity)entity).getInputStream()), (Charset)((Charset)mediaType.getCharset().get()));
                        }
                        catch (IllegalArgumentException e) {
                            throw new HttpMessageParsingException(I18nMessageFactory.createStaticMessage((String)"Cannot decode %s payload", (Object[])new Object[]{HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.getSubType()}), e);
                        }
                    } else if (entity instanceof InputStreamHttpEntity) {
                        payload = ((InputStreamHttpEntity)entity).getInputStream();
                    }
                } else if (entity instanceof InputStreamHttpEntity) {
                    payload = ((InputStreamHttpEntity)entity).getInputStream();
                }
            }
        } else {
            InputStreamHttpEntity inputStreamEntity = request.getInputStreamEntity();
            if (inputStreamEntity != null) {
                payload = inputStreamEntity.getInputStream();
            }
        }
        InternalMessage message = InternalMessage.builder().payload((Object)payload).mediaType(mediaType).inboundProperties(inboundProperties).outboundProperties(outboundProperties).build();
        return message;
    }

    private static String resolveRemoteHostAddress(HttpRequestContext requestContext) {
        return requestContext.getClientConnection().getRemoteHostAddress().toString();
    }
}

