/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.api.listener;

import java.net.URL;
import java.util.Collection;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.module.http.api.listener.HttpListener;
import org.mule.runtime.module.http.api.listener.HttpListenerConfig;
import org.mule.runtime.module.http.internal.listener.DefaultHttpListener;
import org.mule.runtime.module.http.internal.listener.DefaultHttpListenerConfig;
import org.mule.runtime.module.http.internal.listener.HttpListenerConfigBuilder;
import org.mule.runtime.module.http.internal.listener.HttpResponseBuilder;
import org.mule.service.http.api.HttpConstants;

public class HttpListenerBuilder {
    private static final int MAXIMUM_PORT_NUMBER = 65535;
    private final DefaultHttpListener httpListener;
    private final MuleContext muleContext;
    private String protocol;
    private TlsContextFactory tlsContextFactory;
    private HttpListenerConfig httpListenerConfig;
    private Integer port;
    private String host;
    private String path;
    private Flow flow;
    private HttpResponseBuilder responseBuilder;
    private HttpResponseBuilder errorResponseBuilder;

    public HttpListenerBuilder(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.httpListener = new DefaultHttpListener();
        this.httpListener.setMuleContext(muleContext);
    }

    public HttpListenerBuilder setUrl(URL url) {
        String host = url.getHost();
        Integer port = url.getPort();
        this.protocol = url.getProtocol();
        this.setPort(port);
        this.setHost(host);
        this.setPath(url.getPath());
        return this;
    }

    public HttpListenerBuilder setPort(int port) {
        Preconditions.checkArgument((port > 0 && port < 65535 ? 1 : 0) != 0, (String)"Port number out of range");
        Preconditions.checkState((this.httpListenerConfig == null ? 1 : 0) != 0, (String)"Listener config already specified. A port cannot be specified since the one in the listener config will be used");
        Preconditions.checkState((this.port == null ? 1 : 0) != 0, (String)"Port already specified");
        this.port = port;
        return this;
    }

    public HttpListenerBuilder setHost(String host) {
        Preconditions.checkState((this.httpListenerConfig == null ? 1 : 0) != 0, (String)"You already set a listener config. You cannot specify the host");
        Preconditions.checkState((this.host == null ? 1 : 0) != 0, (String)"You already specify a host");
        this.host = host;
        return this;
    }

    public HttpListenerBuilder setFlow(Flow flow) {
        this.flow = flow;
        return this;
    }

    public HttpListenerBuilder setSuccessStatusCode(String statusCode) {
        this.getResponseBuilder().setStatusCode(statusCode);
        return this;
    }

    public HttpListenerBuilder setSuccessReasonPhrase(String reasonPhrase) {
        this.getResponseBuilder().setReasonPhrase(reasonPhrase);
        return this;
    }

    public HttpListenerBuilder setErrorStatusCode(String statusCode) {
        this.getErrorResponseBuilder().setStatusCode(statusCode);
        return this;
    }

    public HttpListenerBuilder setErrorReasonPhrase(String reasonPhrase) {
        this.getErrorResponseBuilder().setReasonPhrase(reasonPhrase);
        return this;
    }

    private HttpResponseBuilder getResponseBuilder() {
        if (this.responseBuilder == null) {
            this.responseBuilder = new HttpResponseBuilder();
        }
        return this.responseBuilder;
    }

    private HttpResponseBuilder getErrorResponseBuilder() {
        if (this.errorResponseBuilder == null) {
            this.errorResponseBuilder = new HttpResponseBuilder();
        }
        return this.errorResponseBuilder;
    }

    public HttpListenerBuilder setTlsContextFactory(TlsContextFactory tlsContextFactory) {
        Preconditions.checkState((this.httpListenerConfig == null ? 1 : 0) != 0, (String)"You already set a listener config. You cannot specify a tls context factory");
        Preconditions.checkState((this.protocol == null || this.protocol.equalsIgnoreCase(HttpConstants.Protocols.HTTPS.getScheme()) ? 1 : 0) != 0, (String)"You cannot set a tls context factory with protocol http");
        this.tlsContextFactory = tlsContextFactory;
        this.protocol = HttpConstants.Protocols.HTTPS.getScheme();
        return this;
    }

    public HttpListenerBuilder setPath(String path) {
        Preconditions.checkState((this.path == null ? 1 : 0) != 0, (String)"You already specify a path");
        this.path = path;
        return this;
    }

    public HttpListener build() throws MuleException {
        try {
            Preconditions.checkState((this.flow != null ? 1 : 0) != 0, (String)"You must configure a flow");
            this.resolveListenerConfig();
            if (this.protocol != null && this.protocol.toLowerCase().equals(HttpConstants.Protocols.HTTPS.getScheme())) {
                if (this.httpListenerConfig == null) {
                    throw new DefaultMuleException(CoreMessages.createStaticMessage((String)"Protocol is https but there is not listener config provided. A listener config with tls configuration is required."));
                }
                if (!this.httpListenerConfig.hasTlsConfig()) {
                    throw new DefaultMuleException(CoreMessages.createStaticMessage((String)"Provided listener config must have tls configured since the listening protocol is https"));
                }
            }
            this.httpListener.setFlowConstruct((FlowConstruct)this.flow);
            this.httpListener.setPath(this.path);
            this.httpListener.setListener((Processor)this.flow);
            this.httpListener.setConfig((DefaultHttpListenerConfig)this.httpListenerConfig);
            if (this.responseBuilder != null) {
                this.responseBuilder.setMuleContext(this.muleContext);
                this.responseBuilder.initialise();
                this.httpListener.setResponseBuilder(this.responseBuilder);
            }
            if (this.errorResponseBuilder != null) {
                this.responseBuilder.setMuleContext(this.muleContext);
                this.errorResponseBuilder.initialise();
                this.httpListener.setErrorResponseBuilder(this.errorResponseBuilder);
            }
            return this.httpListener;
        }
        catch (InitialisationException e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    public HttpListenerBuilder setListenerConfig(HttpListenerConfig httpListenerConfig) {
        Preconditions.checkState((this.tlsContextFactory == null ? 1 : 0) != 0, (String)"You cannot configure a listener config if you provided a tls context factory");
        this.httpListenerConfig = httpListenerConfig;
        return this;
    }

    private void resolveListenerConfig() throws MuleException {
        if (this.httpListenerConfig == null) {
            Collection listenerConfigs = this.muleContext.getRegistry().lookupObjects(HttpListenerConfig.class);
            for (HttpListenerConfig listenerConfig : listenerConfigs) {
                if (!listenerConfig.getHost().equals(this.host) || listenerConfig.getPort() != this.port.intValue() || this.protocol != null && (!this.protocol.equalsIgnoreCase(HttpConstants.Protocols.HTTPS.getScheme()) || !listenerConfig.hasTlsConfig()) && (!this.protocol.equalsIgnoreCase(HttpConstants.Protocols.HTTP.getScheme()) || listenerConfig.hasTlsConfig())) continue;
                if (this.tlsContextFactory != null && !this.tlsContextFactory.equals(listenerConfig.getTlsContext())) {
                    throw new IllegalStateException(String.format("There's already a listener configuration with TLS configuration defined for host(%s) and port(%s)", this.host, this.port));
                }
                this.httpListenerConfig = listenerConfig;
                break;
            }
            if (this.httpListenerConfig == null) {
                HttpListenerConfigBuilder httpListenerConfigBuilder = new HttpListenerConfigBuilder(this.muleContext).setHost(this.host).setPort(this.port);
                if (this.protocol != null && this.protocol.equalsIgnoreCase(HttpConstants.Protocols.HTTPS.getScheme())) {
                    if (this.tlsContextFactory == null) {
                        throw new IllegalStateException("Cannot create a listener for http without a TLS context provided");
                    }
                    httpListenerConfigBuilder.setTlsContextFactory(this.tlsContextFactory);
                } else if (this.protocol == null && this.tlsContextFactory != null) {
                    httpListenerConfigBuilder.setTlsContextFactory(this.tlsContextFactory);
                }
                this.httpListenerConfig = httpListenerConfigBuilder.build();
            }
        }
    }
}

