/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.error.HttpMessageParsingException;
import org.mule.extension.http.internal.request.HttpRequesterCookieConfig;
import org.mule.extension.http.internal.request.builder.HttpResponseAttributesBuilder;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.SystemUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.http.internal.multipart.HttpPartDataSource;
import org.mule.runtime.module.http.internal.util.HttpToMuleMessage;
import org.mule.service.http.api.HttpHeaders;
import org.mule.service.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.service.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.api.utils.HttpEncoderDecoderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseToResult {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseToResult.class);
    private static final String MULTI_PART_PREFIX = "multipart/";
    private final Boolean parseResponse;
    private final HttpRequesterCookieConfig config;
    private final MuleContext muleContext;

    public HttpResponseToResult(HttpRequesterCookieConfig config, Boolean parseResponse, MuleContext muleContext) {
        this.config = config;
        this.parseResponse = parseResponse;
        this.muleContext = muleContext;
    }

    public Result<Object, HttpResponseAttributes> convert(MediaType mediaType, HttpResponse response, String uri) throws HttpMessageParsingException {
        String responseContentType = response.getHeaderValueIgnoreCase("Content-Type");
        if (StringUtils.isEmpty((String)responseContentType) && !MediaType.ANY.matches(mediaType)) {
            responseContentType = mediaType.toRfcString();
        }
        InputStream responseInputStream = ((InputStreamHttpEntity)response.getEntity()).getInputStream();
        Charset encoding = (Charset)HttpToMuleMessage.getMediaType(responseContentType, SystemUtils.getDefaultEncoding((MuleContext)this.muleContext)).getCharset().get();
        InputStream payload = responseInputStream;
        if (responseContentType != null && this.parseResponse.booleanValue()) {
            if (responseContentType.startsWith(MULTI_PART_PREFIX)) {
                try {
                    payload = HttpPartDataSource.multiPartPayloadForAttachments(responseContentType, responseInputStream);
                }
                catch (IOException e) {
                    throw new HttpMessageParsingException(I18nMessageFactory.createStaticMessage((String)"Unable to process multipart response"), e);
                }
            } else if (responseContentType.startsWith(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString())) {
                payload = HttpEncoderDecoderUtils.decodeUrlEncodedBody((String)IOUtils.toString((InputStream)responseInputStream), (Charset)encoding);
            }
        }
        if (this.config.isEnableCookies()) {
            this.processCookies(response, uri);
        }
        HttpResponseAttributes responseAttributes = this.createAttributes(response);
        mediaType = DataType.builder().mediaType(mediaType).charset(encoding).build().getMediaType();
        Result.Builder builder = Result.builder().output((Object)payload);
        if (StringUtils.isEmpty((String)responseContentType)) {
            builder.mediaType(mediaType);
        } else {
            builder.mediaType(MediaType.parse((String)responseContentType));
        }
        return builder.attributes((Attributes)responseAttributes).build();
    }

    private HttpResponseAttributes createAttributes(HttpResponse response) {
        return new HttpResponseAttributesBuilder().setResponse(response).build();
    }

    private void processCookies(HttpResponse response, String uri) {
        Collection setCookieHeader = response.getHeaderValuesIgnoreCase("Set-Cookie");
        Collection setCookie2Header = response.getHeaderValuesIgnoreCase("Set-Cookie2");
        HashMap<String, List<String>> cookieHeaders = new HashMap<String, List<String>>();
        if (setCookieHeader != null) {
            cookieHeaders.put("Set-Cookie", new ArrayList(setCookieHeader));
        }
        if (setCookie2Header != null) {
            cookieHeaders.put("Set-Cookie2", new ArrayList(setCookie2Header));
        }
        try {
            this.config.getCookieManager().put(URI.create(uri), cookieHeaders);
        }
        catch (IOException e) {
            logger.warn("Error storing cookies for URI " + uri, (Throwable)e);
        }
    }
}

