/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.InputStream;
import java.util.concurrent.TimeoutException;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.HttpSendBodyMode;
import org.mule.extension.http.api.HttpStreamingType;
import org.mule.extension.http.api.error.HttpError;
import org.mule.extension.http.api.request.authentication.HttpAuthentication;
import org.mule.extension.http.api.request.authentication.UsernamePasswordAuthentication;
import org.mule.extension.http.api.request.builder.HttpRequesterRequestBuilder;
import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.extension.http.api.request.validator.ResponseValidator;
import org.mule.extension.http.internal.request.HttpRequestFactory;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.extension.http.internal.request.HttpResponseToResult;
import org.mule.extension.http.internal.request.client.HttpExtensionClient;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.TransformationService;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.context.notification.ConnectorMessageNotification;
import org.mule.runtime.core.context.notification.NotificationHelper;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.service.http.api.HttpConstants;
import org.mule.service.http.api.client.HttpRequestAuthentication;
import org.mule.service.http.api.client.async.ResponseHandler;
import org.mule.service.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequester {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequester.class);
    private static final String REMOTELY_CLOSED = "Remotely closed";
    private final boolean followRedirects;
    private final HttpAuthentication authentication;
    private final boolean parseResponse;
    private final int responseTimeout;
    private final ResponseValidator responseValidator;
    private final HttpRequesterConfig config;
    private final NotificationHelper notificationHelper;
    private final HttpRequestFactory eventToHttpRequest;
    private final Scheduler scheduler;

    public HttpRequester(HttpRequestFactory eventToHttpRequest, boolean followRedirects, HttpAuthentication authentication, boolean parseResponse, int responseTimeout, ResponseValidator responseValidator, HttpRequesterConfig config, Scheduler scheduler) {
        this.followRedirects = followRedirects;
        this.authentication = authentication;
        this.parseResponse = parseResponse;
        this.responseTimeout = responseTimeout;
        this.responseValidator = responseValidator;
        this.config = config;
        this.scheduler = scheduler;
        this.eventToHttpRequest = eventToHttpRequest;
        this.notificationHelper = new NotificationHelper((ServerNotificationHandler)config.getMuleContext().getNotificationManager(), ConnectorMessageNotification.class, false);
    }

    public void doRequest(HttpExtensionClient client, HttpRequesterRequestBuilder requestBuilder, boolean checkRetry, MuleContext muleContext, CompletionCallback<Object, HttpResponseAttributes> callback) {
        HttpRequest httpRequest = this.eventToHttpRequest.create(requestBuilder, this.authentication, muleContext);
        client.send(httpRequest, this.responseTimeout, this.followRedirects, this.resolveAuthentication(this.authentication), this.createResponseHandler(muleContext, requestBuilder, client, httpRequest, checkRetry, callback));
    }

    private ResponseHandler createResponseHandler(final MuleContext muleContext, final HttpRequesterRequestBuilder requestBuilder, final HttpExtensionClient client, final HttpRequest httpRequest, final boolean checkRetry, final CompletionCallback<Object, HttpResponseAttributes> callback) {
        return new ResponseHandler(){

            public void onCompletion(HttpResponse response) {
                HttpRequester.this.scheduler.execute(() -> {
                    HttpResponseToResult httpResponseToResult = new HttpResponseToResult(HttpRequester.this.config, HttpRequester.this.parseResponse, muleContext);
                    try {
                        MediaType mediaType = requestBuilder.getBody().getDataType().getMediaType();
                        Result<Object, HttpResponseAttributes> result = httpResponseToResult.convert(mediaType, response, httpRequest.getUri());
                        if (HttpRequester.this.resendRequest(result, checkRetry, HttpRequester.this.authentication)) {
                            HttpRequester.this.consumePayload(result);
                            HttpRequester.this.doRequest(client, requestBuilder, false, muleContext, (CompletionCallback<Object, HttpResponseAttributes>)callback);
                        } else {
                            HttpRequester.this.responseValidator.validate(result);
                            callback.success(result);
                        }
                    }
                    catch (Exception e) {
                        callback.error(e);
                    }
                });
            }

            public void onFailure(Exception exception) {
                HttpRequester.this.checkIfRemotelyClosed(exception, client.getDefaultUriParameters());
                logger.error(HttpRequester.this.getErrorMessage(httpRequest));
                HttpError error = exception instanceof TimeoutException ? HttpError.TIMEOUT : HttpError.CONNECTIVITY;
                callback.error((Exception)new ModuleException((Throwable)exception, (ErrorTypeDefinition)error));
            }
        };
    }

    private String getErrorMessage(HttpRequest httpRequest) {
        return String.format("Error sending HTTP request to %s", httpRequest.getUri());
    }

    private boolean resendRequest(Result result, boolean retry, HttpAuthentication authentication) throws MuleException {
        return retry && authentication != null && authentication.shouldRetry((Result<Object, HttpResponseAttributes>)result);
    }

    private void consumePayload(Result result) {
        if (result.getOutput() instanceof InputStream) {
            try {
                IOUtils.toByteArray((InputStream)((InputStream)result.getOutput()));
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    private HttpRequestAuthentication resolveAuthentication(HttpAuthentication authentication) {
        HttpRequestAuthentication requestAuthentication = null;
        if (authentication instanceof UsernamePasswordAuthentication) {
            requestAuthentication = ((UsernamePasswordAuthentication)authentication).buildRequestAuthentication();
        }
        return requestAuthentication;
    }

    private void checkIfRemotelyClosed(Exception exception, UriParameters uriParameters) {
        if (HttpConstants.Protocols.HTTPS.getScheme().equals(uriParameters.getScheme()) && StringUtils.containsIgnoreCase((String)exception.getMessage(), (String)REMOTELY_CLOSED)) {
            logger.error("Remote host closed connection. Possible SSL/TLS handshake issue. Check protocols, cipher suites and certificate set up. Use -Djavax.net.debug=handshake for further debugging.");
        }
    }

    public static class Builder {
        private String uri;
        private String method;
        private boolean followRedirects;
        private HttpStreamingType requestStreamingMode;
        private HttpSendBodyMode sendBodyMode;
        private HttpAuthentication authentication;
        private int responseTimeout;
        private boolean parseResponse;
        private ResponseValidator responseValidator;
        private HttpRequesterConfig config;
        private TransformationService transformationService;
        private Scheduler scheduler;

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder setRequestStreamingMode(HttpStreamingType requestStreamingMode) {
            this.requestStreamingMode = requestStreamingMode;
            return this;
        }

        public Builder setSendBodyMode(HttpSendBodyMode sendBodyMode) {
            this.sendBodyMode = sendBodyMode;
            return this;
        }

        public Builder setAuthentication(HttpAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public Builder setParseResponse(boolean parseResponse) {
            this.parseResponse = parseResponse;
            return this;
        }

        public Builder setResponseTimeout(int responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        public Builder setResponseValidator(ResponseValidator responseValidator) {
            this.responseValidator = responseValidator;
            return this;
        }

        public Builder setConfig(HttpRequesterConfig config) {
            this.config = config;
            return this;
        }

        public Builder setTransformationService(TransformationService transformationService) {
            this.transformationService = transformationService;
            return this;
        }

        public Builder setScheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public HttpRequester build() {
            HttpRequestFactory eventToHttpRequest = new HttpRequestFactory(this.config, this.uri, this.method, this.requestStreamingMode, this.sendBodyMode, this.transformationService);
            return new HttpRequester(eventToHttpRequest, this.followRedirects, this.authentication, this.parseResponse, this.responseTimeout, this.responseValidator, this.config, this.scheduler);
        }
    }
}

