/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.http.internal.multipart;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.message.DefaultMultiPartPayload;
import org.mule.runtime.core.message.PartAttributes;
import org.mule.runtime.core.message.ds.ByteArrayDataSource;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.http.internal.HttpParser;
import org.mule.service.http.api.domain.entity.multipart.HttpPart;
import org.mule.service.http.api.domain.entity.multipart.MultipartHttpEntity;

public class HttpPartDataSource
implements DataSource {
    private final HttpPart part;
    private byte[] content;

    private HttpPartDataSource(HttpPart part) {
        try {
            this.part = part;
            this.content = IOUtils.toByteArray((InputStream)part.getInputStream());
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public byte[] getContent() throws IOException {
        return this.content;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getContent());
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        return this.part.getContentType();
    }

    public String getHeader(String headerName) {
        return this.part.getHeader(headerName);
    }

    public String getName() {
        return this.part.getName();
    }

    public static Collection<HttpPart> createFrom(Map<String, DataHandler> parts) throws IOException {
        ArrayList<HttpPart> httpParts = new ArrayList<HttpPart>(parts.size());
        for (String partName : parts.keySet()) {
            DataHandler dataHandlerPart = parts.get(partName);
            if (dataHandlerPart.getDataSource() instanceof HttpPartDataSource) {
                httpParts.add(((HttpPartDataSource)dataHandlerPart.getDataSource()).getPart());
                continue;
            }
            byte[] data = IOUtils.toByteArray((InputStream)dataHandlerPart.getInputStream());
            String fileName = null;
            if (dataHandlerPart.getDataSource() instanceof FileDataSource || dataHandlerPart.getDataSource() instanceof ByteArrayDataSource) {
                fileName = dataHandlerPart.getDataSource().getName();
            }
            httpParts.add(new HttpPart(partName, fileName, data, dataHandlerPart.getContentType(), data.length));
        }
        return httpParts;
    }

    public static Collection<HttpPart> createFrom(MultiPartPayload multiPartPayload, Transformer objectToByteArray) {
        return multiPartPayload.getParts().stream().map(message -> {
            PartAttributes partAttributes = (PartAttributes)message.getAttributes();
            TypedValue payload = message.getPayload();
            String name = partAttributes.getName();
            try {
                byte[] data = (byte[])objectToByteArray.transform(payload.getValue());
                String fileName = partAttributes.getFileName();
                String contentType = payload.getDataType().getMediaType().toRfcString();
                int size = Math.toIntExact(partAttributes.getSize());
                if (fileName != null) {
                    return new HttpPart(name, fileName, data, contentType, size);
                }
                return new HttpPart(name, data, contentType, size);
            }
            catch (TransformerException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not create HTTP part %s", name), (Object[])new Object[]{e}));
            }
        }).collect(Collectors.toList());
    }

    public static MultiPartPayload multiPartPayloadForAttachments(MultipartHttpEntity entity) throws IOException {
        return HttpPartDataSource.multiPartPayloadForAttachments(entity.getParts());
    }

    public static MultiPartPayload multiPartPayloadForAttachments(String responseContentType, InputStream responseInputStream) throws IOException {
        return HttpPartDataSource.multiPartPayloadForAttachments(HttpParser.parseMultipartContent(responseInputStream, responseContentType));
    }

    private static MultiPartPayload multiPartPayloadForAttachments(Collection<HttpPart> httpParts) throws IOException {
        ArrayList<InternalMessage> parts = new ArrayList<InternalMessage>();
        int partNumber = 1;
        for (HttpPart httpPart : httpParts) {
            HashMap headers = new HashMap();
            for (String headerName : httpPart.getHeaderNames()) {
                if (!headers.containsKey(headerName)) {
                    headers.put(headerName, new LinkedList());
                }
                ((LinkedList)headers.get(headerName)).addAll(httpPart.getHeaders(headerName));
            }
            parts.add(InternalMessage.builder().payload((Object)httpPart.getInputStream()).mediaType(MediaType.parse((String)httpPart.getContentType())).attributes((Attributes)new PartAttributes(httpPart.getName() != null ? httpPart.getName() : "part_" + partNumber, httpPart.getFileName(), httpPart.getSize(), headers)).build());
            ++partNumber;
        }
        return new DefaultMultiPartPayload(parts);
    }

    public HttpPart getPart() {
        return this.part;
    }
}

