/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import javax.inject.Inject;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.HttpSendBodyMode;
import org.mule.extension.http.api.HttpStreamingType;
import org.mule.extension.http.api.request.builder.HttpRequesterRequestBuilder;
import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.extension.http.api.request.validator.ResponseValidator;
import org.mule.extension.http.api.request.validator.SuccessStatusCodeValidator;
import org.mule.extension.http.internal.HttpRequestMetadataResolver;
import org.mule.extension.http.internal.request.ConfigurationOverrides;
import org.mule.extension.http.internal.request.HttpRequester;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.extension.http.internal.request.OutputSettings;
import org.mule.extension.http.internal.request.RequestErrorTypeProvider;
import org.mule.extension.http.internal.request.ResponseValidationSettings;
import org.mule.extension.http.internal.request.client.HttpExtensionClient;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.service.http.api.HttpConstants;
import org.mule.service.http.api.utils.HttpEncoderDecoderUtils;

public class HttpRequestOperations
implements Initialisable,
Disposable {
    private static final int WAIT_FOR_EVER = Integer.MAX_VALUE;
    @Inject
    private MuleContext muleContext;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;

    @Summary(value="Executes a HTTP Request")
    @OutputResolver(output=HttpRequestMetadataResolver.class)
    @Throws(value={RequestErrorTypeProvider.class})
    public void request(@Optional(defaultValue="/") String path, @Optional(defaultValue="GET") String method, @ParameterGroup(name="Configuration Overrides") ConfigurationOverrides overrides, @ParameterGroup(name="Response Validation Settings") ResponseValidationSettings responseValidationSettings, @ParameterGroup(name="Request Settings") HttpRequesterRequestBuilder requestBuilder, @ParameterGroup(name="Other Settings") OutputSettings outputSettings, @Connection HttpExtensionClient client, @UseConfig HttpRequesterConfig config, CompletionCallback<Object, HttpResponseAttributes> callback) {
        try {
            HttpRequesterRequestBuilder resolvedBuilder = requestBuilder != null ? requestBuilder : new HttpRequesterRequestBuilder();
            UriParameters uriParameters = client.getDefaultUriParameters();
            String resolvedHost = this.resolveIfNecessary(overrides.getHost(), uriParameters.getHost());
            Integer resolvedPort = this.resolveIfNecessary(overrides.getPort(), uriParameters.getPort());
            String resolvedBasePath = config.getBasePath();
            String resolvedPath = resolvedBuilder.replaceUriParams(this.buildPath(resolvedBasePath, path));
            String resolvedUri = this.resolveUri(uriParameters.getScheme(), resolvedHost, resolvedPort, resolvedPath);
            Boolean resolvedFollowRedirects = this.resolveIfNecessary(overrides.getFollowRedirects(), config.getFollowRedirects());
            HttpStreamingType resolvedStreamingMode = this.resolveIfNecessary(overrides.getRequestStreamingMode(), config.getRequestStreamingMode());
            HttpSendBodyMode resolvedSendBody = this.resolveIfNecessary(overrides.getSendBodyMode(), config.getSendBodyMode());
            Boolean resolvedParseResponse = this.resolveIfNecessary(overrides.getParseResponse(), config.getParseResponse());
            Integer resolvedTimeout = this.resolveResponseTimeout(config, overrides.getResponseTimeout());
            ResponseValidator responseValidator = responseValidationSettings.getResponseValidator();
            responseValidator = responseValidator != null ? responseValidator : new SuccessStatusCodeValidator("0..399");
            HttpRequester requester = new HttpRequester.Builder().setUri(resolvedUri).setMethod(method).setFollowRedirects(resolvedFollowRedirects).setRequestStreamingMode(resolvedStreamingMode).setSendBodyMode(resolvedSendBody).setAuthentication(client.getDefaultAuthentication()).setParseResponse(resolvedParseResponse).setResponseTimeout(resolvedTimeout).setResponseValidator(responseValidator).setConfig(config).setTransformationService(this.muleContext.getTransformationService()).setScheduler(this.scheduler).build();
            requester.doRequest(client, resolvedBuilder, true, this.muleContext, callback);
        }
        catch (Exception e) {
            callback.error(e);
        }
    }

    private <T> T resolveIfNecessary(T value, T configValue) {
        return value != null ? value : configValue;
    }

    private String resolveUri(HttpConstants.Protocols scheme, String host, Integer port, String path) {
        return String.format("%s://%s:%s%s", scheme.getScheme(), host, port, HttpEncoderDecoderUtils.encodeSpaces((String)path));
    }

    private int resolveResponseTimeout(HttpRequesterConfig config, Integer responseTimeout) {
        if (responseTimeout == null && config.getResponseTimeout() != null) {
            responseTimeout = config.getResponseTimeout();
        }
        if (this.muleContext.getConfiguration().isDisableTimeouts()) {
            return Integer.MAX_VALUE;
        }
        return responseTimeout != null ? responseTimeout.intValue() : this.muleContext.getConfiguration().getDefaultResponseTimeout();
    }

    protected String buildPath(String basePath, String path) {
        String resolvedBasePath = basePath;
        String resolvedRequestPath = path;
        if (!resolvedBasePath.startsWith("/")) {
            resolvedBasePath = "/" + resolvedBasePath;
        }
        if (resolvedBasePath.endsWith("/") && resolvedRequestPath.startsWith("/")) {
            resolvedBasePath = resolvedBasePath.substring(0, resolvedBasePath.length() - 1);
        }
        if (!(resolvedBasePath.endsWith("/") || resolvedRequestPath.startsWith("/") || resolvedRequestPath.isEmpty())) {
            resolvedBasePath = resolvedBasePath + "/";
        }
        return resolvedBasePath + resolvedRequestPath;
    }

    public void initialise() throws InitialisationException {
        this.scheduler = this.schedulerService.ioScheduler();
    }

    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }
}

