/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.error.HttpMessageParsingException;
import org.mule.extension.http.internal.listener.HttpRequestAttributesBuilder;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.http.internal.listener.ListenerPath;
import org.mule.runtime.module.http.internal.multipart.HttpPartDataSource;
import org.mule.runtime.module.http.internal.util.HttpToMuleMessage;
import org.mule.service.http.api.HttpHeaders;
import org.mule.service.http.api.domain.entity.EmptyHttpEntity;
import org.mule.service.http.api.domain.entity.HttpEntity;
import org.mule.service.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.service.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.service.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.api.domain.request.HttpRequestContext;
import org.mule.service.http.api.utils.HttpEncoderDecoderUtils;

public class HttpRequestToResult {
    public static Result<Object, HttpRequestAttributes> transform(HttpRequestContext requestContext, Charset encoding, Boolean parseRequest, ListenerPath listenerPath) throws HttpMessageParsingException {
        HttpRequest request = requestContext.getRequest();
        MediaType mediaType = HttpToMuleMessage.getMediaType(request.getHeaderValueIgnoreCase("Content-Type"), encoding);
        InputStream payload = null;
        if (parseRequest.booleanValue()) {
            HttpEntity entity = request.getEntity();
            if (entity != null && !(entity instanceof EmptyHttpEntity)) {
                if (entity instanceof MultipartHttpEntity) {
                    try {
                        payload = HttpPartDataSource.multiPartPayloadForAttachments((MultipartHttpEntity)entity);
                    }
                    catch (IOException e) {
                        throw new HttpMessageParsingException(I18nMessageFactory.createStaticMessage((String)"Unable to process multipart request"), e);
                    }
                } else if (mediaType != null) {
                    if (mediaType.matches(HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED)) {
                        try {
                            payload = HttpEncoderDecoderUtils.decodeUrlEncodedBody((String)IOUtils.toString((InputStream)((InputStreamHttpEntity)entity).getInputStream()), (Charset)((Charset)mediaType.getCharset().get()));
                        }
                        catch (IllegalArgumentException e) {
                            throw new HttpMessageParsingException(I18nMessageFactory.createStaticMessage((String)"Cannot decode %s payload", (Object[])new Object[]{HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.getSubType()}), e);
                        }
                    } else if (entity instanceof InputStreamHttpEntity) {
                        payload = ((InputStreamHttpEntity)entity).getInputStream();
                    }
                } else if (entity instanceof InputStreamHttpEntity) {
                    payload = ((InputStreamHttpEntity)entity).getInputStream();
                }
            }
        } else {
            InputStreamHttpEntity inputStreamEntity = request.getInputStreamEntity();
            if (inputStreamEntity != null) {
                payload = inputStreamEntity.getInputStream();
            }
        }
        HttpRequestAttributes attributes = new HttpRequestAttributesBuilder().setRequestContext(requestContext).setListenerPath(listenerPath).build();
        return Result.builder().output((Object)payload).mediaType(mediaType).attributes((Attributes)attributes).build();
    }
}

