/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.error;

import java.util.Optional;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.service.http.api.HttpConstants;

public enum HttpError implements ErrorTypeDefinition<HttpError>
{
    PARSING,
    TIMEOUT,
    SECURITY((ErrorTypeDefinition<?>)MuleErrors.SECURITY),
    TRANSFORMATION((ErrorTypeDefinition<?>)MuleErrors.TRANSFORMATION),
    CONNECTIVITY((ErrorTypeDefinition<?>)MuleErrors.CONNECTIVITY),
    RESPONSE_VALIDATION((ErrorTypeDefinition<?>)MuleErrors.ANY),
    BAD_REQUEST(RESPONSE_VALIDATION),
    UNAUTHORIZED(RESPONSE_VALIDATION),
    FORBIDDEN(RESPONSE_VALIDATION),
    NOT_FOUND(RESPONSE_VALIDATION),
    METHOD_NOT_ALLOWED(RESPONSE_VALIDATION),
    NOT_ACCEPTABLE(RESPONSE_VALIDATION),
    UNSUPPORTED_MEDIA_TYPE(RESPONSE_VALIDATION),
    TOO_MANY_REQUESTS(RESPONSE_VALIDATION),
    INTERNAL_SERVER_ERROR(RESPONSE_VALIDATION),
    SERVICE_UNAVAILABLE(RESPONSE_VALIDATION);

    private ErrorTypeDefinition<?> parentErrorType;

    private HttpError() {
    }

    private HttpError(ErrorTypeDefinition<?> parentErrorType) {
        this.parentErrorType = parentErrorType;
    }

    public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
        return Optional.ofNullable(this.parentErrorType);
    }

    public static Optional<HttpError> getErrorByCode(int statusCode) {
        HttpError error = null;
        HttpConstants.HttpStatus status = HttpConstants.HttpStatus.getStatusByCode((int)statusCode);
        if (status != null) {
            try {
                error = HttpError.valueOf(status.name());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Optional.ofNullable(error);
    }

    public static Optional<HttpConstants.HttpStatus> getHttpStatus(HttpError error) {
        HttpConstants.HttpStatus result = null;
        for (HttpConstants.HttpStatus status : HttpConstants.HttpStatus.values()) {
            if (!error.name().equals(status.name())) continue;
            result = status;
        }
        return Optional.ofNullable(result);
    }
}

